/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import moa.gui.experimentertab.Summary;
import moa.gui.experimentertab.SummaryTable;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;

public class SummaryViewer
extends JFrame {
    public JTable tableSummary;
    public JScrollPane scroll;
    public JPanel jTablePanel;
    public JComboBox summaryType;
    public JButton bntExport;
    public SummaryTable[] summaryTable;
    public Summary summary;
    public String resultsPath;

    public SummaryViewer(SummaryTable[] summaryTable, Summary summary, String resultsPath) throws HeadlessException {
        super("Summary Viewer");
        this.setDefaultCloseOperation(1);
        this.summaryTable = summaryTable;
        this.summary = summary;
        this.resultsPath = resultsPath;
        JLabel label = new JLabel("Summary");
        this.tableSummary = new JTable();
        String[] op = new String[this.summaryTable.length];
        for (int i = 0; i < this.summaryTable.length; ++i) {
            op[i] = this.summaryTable[i].measureName;
        }
        this.tableSummary.setModel(new DefaultTableModel(this.summaryTable[0].value, this.summaryTable[0].algNames));
        this.scroll = new JScrollPane();
        this.scroll.setViewportView(this.tableSummary);
        JPanel panel = new JPanel();
        JPanel main = new JPanel();
        this.jTablePanel = new JPanel();
        this.jTablePanel.setLayout(new GridLayout(1, 0));
        this.jTablePanel.add(this.scroll);
        this.summaryType = new JComboBox<String>(op);
        this.summaryType.setSelectedIndex(0);
        this.bntExport = new JButton("Export Summaries");
        this.summaryType.addItemListener(this::summaryTypeItemStateChanged);
        this.bntExport.addActionListener(this::btnExportActionPerformed);
        panel.add(label);
        panel.add(this.summaryType);
        panel.add(this.bntExport);
        main.setLayout(new BorderLayout());
        main.add((Component)this.jTablePanel, "Center");
        main.add((Component)panel, "South");
        this.setContentPane(main);
        this.pack();
        this.setSize(700, 500);
        this.setVisible(true);
    }

    private void summaryTypeItemStateChanged(ItemEvent evt) {
        for (SummaryTable summary1 : this.summaryTable) {
            if (!this.summaryType.getSelectedItem().equals(summary1.measureName)) continue;
            this.tableSummary.setModel(new DefaultTableModel(summary1.value, summary1.algNames));
            break;
        }
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        String path = "";
        BaseDirectoryChooser propDir = new BaseDirectoryChooser();
        propDir.setFileSelectionMode(1);
        propDir.setCurrentDirectory(new File(this.resultsPath));
        int selection = propDir.showSaveDialog((Component)this);
        if (selection == 0) {
            path = propDir.getSelectedFile().getAbsolutePath();
        }
        if (!path.equals("")) {
            path = path + File.separator;
            this.summary.invertedSumariesPerMeasure(path);
            this.summary.computeWinsTiesLossesHTML(path);
            this.summary.computeWinsTiesLossesLatex(path);
            this.summary.generateHTML(path);
            this.summary.generateLatex(path);
            JOptionPane.showMessageDialog(this, "Summaries created at: " + path, "", 1);
        }
    }
}

