/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.classifiers.Classifier;
import moa.core.ObjectRepository;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.evaluation.LearningEvaluation;
import moa.options.ClassOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateModel
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption modelOption = new ClassOption("model", 'm', "Classifier to evaluate.", Classifier.class, "LearnModel");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to evaluate on.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", ClassificationPerformanceEvaluator.class, "BasicClassificationPerformanceEvaluator");
    public IntOption maxInstancesOption = new IntOption("maxInstances", 'i', "Maximum number of instances to test.", 1000000, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Evaluates a static model on a stream.";
    }

    public EvaluateModel() {
    }

    public EvaluateModel(Classifier model, InstanceStream stream, ClassificationPerformanceEvaluator evaluator, int maxInstances) {
        this.modelOption.setCurrentObject(model);
        this.streamOption.setCurrentObject(stream);
        this.evaluatorOption.setCurrentObject(evaluator);
        this.maxInstancesOption.setValue(maxInstances);
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningEvaluation.class;
    }

    @Override
    public Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Classifier model = (Classifier)this.getPreparedClassOption(this.modelOption);
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        ClassificationPerformanceEvaluator evaluator = (ClassificationPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        int maxInstances = this.maxInstancesOption.getValue();
        long instancesProcessed = 0L;
        monitor.setCurrentActivity("Evaluating model...", -1.0);
        while (stream.hasMoreInstances() && (maxInstances < 0 || instancesProcessed < (long)maxInstances)) {
            Instance testInst = (Instance)stream.nextInstance().copy();
            int trueClass = (int)testInst.classValue();
            double[] prediction = model.getVotesForInstance(testInst);
            evaluator.addResult(testInst, prediction);
            if (++instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (!monitor.resultPreviewRequested()) continue;
            monitor.setLatestResultPreview(new LearningEvaluation(evaluator.getPerformanceMeasurements()));
        }
        return new LearningEvaluation(evaluator.getPerformanceMeasurements());
    }
}

