/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.clustertab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import moa.core.AutoClassDiscovery;
import moa.core.AutoExpandVector;
import moa.evaluation.MeasureCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringEvalPanel
extends JPanel {
    Class<?>[] measure_classes = null;
    ArrayList<JLabel> labels = null;
    ArrayList<JCheckBox> checkboxes = null;
    private JPanel contentPanel;
    private JScrollPane scrollPane;

    public ClusteringEvalPanel() {
        this.initComponents();
        this.measure_classes = this.findMeasureClasses();
        this.labels = new ArrayList();
        this.checkboxes = new ArrayList();
        this.addComponents();
    }

    private void addComponents() {
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(4, 7, 4, 7);
        int counter = 0;
        for (int i = 0; i < this.measure_classes.length; ++i) {
            try {
                MeasureCollection m = (MeasureCollection)this.measure_classes[i].newInstance();
                for (int j = 0; j < m.getNumMeasures(); ++j) {
                    String t = m.getName(j);
                    JLabel l = new JLabel(m.getName(j));
                    l.setPreferredSize(new Dimension(100, 14));
                    gb.gridx = 0;
                    gb.gridy = counter;
                    this.labels.add(l);
                    this.contentPanel.add((Component)l, gb);
                    JCheckBox cb = new JCheckBox();
                    if (m.isEnabled(j)) {
                        cb.setSelected(true);
                    } else {
                        cb.setSelected(false);
                    }
                    gb.gridx = 1;
                    this.checkboxes.add(cb);
                    this.contentPanel.add((Component)cb, gb);
                    ++counter;
                }
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger("Couldn't create Instance for " + this.measure_classes[i].getName());
                ex.printStackTrace();
            }
        }
        JLabel dummy = new JLabel();
        gb.gridx = 0;
        ++gb.gridy;
        gb.gridwidth = 3;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        this.add((Component)dummy, gb);
    }

    private Class<?>[] findMeasureClasses() {
        Class[] classesFound;
        AutoExpandVector<Class> finalClasses = new AutoExpandVector<Class>();
        for (Class foundClass : classesFound = AutoClassDiscovery.findClassesOfType("moa.evaluation", MeasureCollection.class)) {
            finalClasses.add(foundClass);
        }
        return finalClasses.toArray(new Class[finalClasses.size()]);
    }

    public MeasureCollection[] getSelectedMeasures() {
        ArrayList<MeasureCollection> measuresSelect = new ArrayList<MeasureCollection>();
        int counter = 0;
        for (int i = 0; i < this.measure_classes.length; ++i) {
            try {
                MeasureCollection m = (MeasureCollection)this.measure_classes[i].newInstance();
                boolean addMeasure = false;
                for (int j = 0; j < m.getNumMeasures(); ++j) {
                    boolean selected = this.checkboxes.get(counter).isSelected();
                    m.setEnabled(j, selected);
                    if (selected) {
                        addMeasure = true;
                    }
                    ++counter;
                }
                if (!addMeasure) continue;
                measuresSelect.add(m);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger("Couldn't create Instance for " + this.measure_classes[i].getName());
                ex.printStackTrace();
            }
        }
        MeasureCollection[] measures = new MeasureCollection[measuresSelect.size()];
        for (int i = 0; i < measures.length; ++i) {
            measures[i] = (MeasureCollection)measuresSelect.get(i);
        }
        return measures;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.contentPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(null, "Evaluation Measures", 0, 0, new Font("Tahoma", 1, 11)));
        this.setLayout(new GridBagLayout());
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setPreferredSize(new Dimension(100, 225));
        this.contentPanel.setLayout(new GridBagLayout());
        this.scrollPane.setViewportView(this.contentPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }
}

