% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_functions.R
\name{make_match_distances}
\alias{make_match_distances}
\title{Make match distances within strata}
\usage{
make_match_distances(object, model, method)
}
\arguments{
\item{object}{a strata object}

\item{model}{(optional) formula for matching.  If left blank, \emph{all}
columns of the analysis set in \code{object} will be used as covariates in
the propensity model or mahalanobis match (except outcome, treatment and
stratum)}

\item{method}{either "prop" for propensity score matching based on a glm fit
with model \code{model}, or "mahal" for mahalanobis distance matching by
the covariates in \code{model}.}
}
\value{
a match distance matrix for optmatch
}
\description{
Makes the match distance with strata specifications for \code{strata_match}.
This function is largely unecessary to call outside of stratamatch, but it is
exported for the benefit of the user to aid in debugging.  Note that this 
function requires that the R package \code{optmatch} is installed.
}
\examples{

dat <- make_sample_data(n = 75)

# stratify with auto_stratify
a.strat <- auto_stratify(dat, "treat", outcome ~ X2, size = 25)

# make match distances.  Requires optmatch package to be installed.
\dontshow{if (requireNamespace("optmatch", quietly = TRUE)) \{}
md <- make_match_distances(a.strat, treat ~ X1 + X2, method = "mahal")
\dontshow{\}}
}
\seealso{
\url{https://cran.r-project.org/package=optmatch}
}
