% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gelato.R
\name{gelato}
\alias{gelato}
\alias{gelatoPlot}
\title{GELATo - Group ExcLusion and Assignment Test}
\usage{
gelato(g, unknown.strata, nrep = 1000, min.sample.size = 5, num.cores = 1)

gelatoPlot(gelato.result, unknown = NULL, main = NULL)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{unknown.strata}{a character vector listing to assign. Strata must 
occur in \code{g}.}

\item{nrep}{number of permutation replicates for Fst distribution.}

\item{min.sample.size}{minimum number of samples to use to characterize 
knowns. If the known sample size would be smaller than this after drawing 
an equivalent number of unknowns for self-assignment, then the comparison 
is not done.}

\item{num.cores}{The number of cores to use to distribute replicates over.
If set to \code{NULL}, the value will be what is reported 
by \code{\link[parallel]{detectCores} - 1}.}

\item{gelato.result}{the result of a call to \code{gelato}.}

\item{unknown}{the names of the unknown strata in the \code{x$likelihoods}
element to create plots. If \code{NULL} one plot for each stratum is
created.}

\item{main}{main label for top of plot.#'}
}
\value{
A list with the following elements:
\tabular{ll}{
  \code{assign.prob} \tab a data.frame of assignment probabilities.\cr
  \code{likelihoods} \tab a list of likelihoods.\cr
}
}
\description{
Run a GELATo test to evaluate assignment likelihoods of 
  groups of samples.
}
\examples{
\dontrun{
data(msats.g)

# Run GELATo analysis
gelato.fine <- gelato(msats.g, unk = "Offshore.South", nrep = 20, num.cores = 2)
gelato.fine

# Plot results
gelatoPlot(gelato.fine, "Offshore.South")
}

}
\references{
O'Corry-Crowe, G., W. Lucey, F.I. Archer, and B. Mahoney. 2015. 
  The genetic ecology and population origins of the beluga whales of 
  Yakutat Bay. Marine Fisheries Review 77(1):47-58
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
