% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtypes.accessors.R
\docType{methods}
\name{gtypes.accessors}
\alias{gtypes.accessors}
\alias{accessors}
\alias{nInd,gtypes-method}
\alias{nInd}
\alias{nLoc,gtypes-method}
\alias{nLoc}
\alias{nStrata}
\alias{nStrata,gtypes-method}
\alias{nStrata}
\alias{indNames,gtypes-method}
\alias{indNames}
\alias{locNames,gtypes-method}
\alias{locNames}
\alias{strataNames}
\alias{strataNames,gtypes-method}
\alias{strataNames}
\alias{ploidy,gtypes-method}
\alias{ploidy}
\alias{other,gtypes-method}
\alias{other}
\alias{strata,gtypes-method}
\alias{strata}
\alias{strata<-}
\alias{strata<-,gtypes-method}
\alias{strata}
\alias{schemes}
\alias{schemes,gtypes-method}
\alias{schemes}
\alias{schemes<-}
\alias{schemes<-,gtypes-method}
\alias{schemes}
\alias{alleleNames}
\alias{alleleNames,gtypes-method}
\alias{alleleNames}
\alias{sequences}
\alias{sequences,gtypes-method}
\alias{sequences}
\alias{description}
\alias{description,gtypes-method}
\alias{description}
\alias{description<-}
\alias{description<-,gtypes-method}
\alias{description}
\alias{[,gtypes,ANY,ANY,ANY-method}
\alias{index}
\alias{subset}
\title{\code{gtypes} Accessors}
\usage{
\S4method{nInd}{gtypes}(x, ...)

\S4method{nLoc}{gtypes}(x, ...)

nStrata(x, ...)

\S4method{nStrata}{gtypes}(x, ...)

\S4method{indNames}{gtypes}(x, ...)

\S4method{locNames}{gtypes}(x, ...)

strataNames(x, ...)

\S4method{strataNames}{gtypes}(x, ...)

\S4method{ploidy}{gtypes}(x, ...)

\S4method{other}{gtypes}(x, ...)

\S4method{strata}{gtypes}(x)

strata(x) <- value

\S4method{strata}{gtypes}(x) <- value

schemes(x, ...)

\S4method{schemes}{gtypes}(x, ...)

schemes(x) <- value

\S4method{schemes}{gtypes}(x) <- value

alleleNames(x, ...)

\S4method{alleleNames}{gtypes}(x)

sequences(x, ...)

\S4method{sequences}{gtypes}(x, seqName = NULL, as.haplotypes = TRUE, ...)

description(x, ...)

\S4method{description}{gtypes}(x, ...)

description(x) <- value

\S4method{description}{gtypes}(x) <- value

\S4method{[}{gtypes,ANY,ANY,ANY}(x, i, j, k, ..., quiet = TRUE,
  drop = FALSE)
}
\arguments{
\item{x}{a \linkS4class{gtypes} object.}

\item{...}{other arguments passed from generics (ignored).}

\item{value}{value being assigned by accessor.}

\item{seqName}{the name (or number) of a set of sequences from the 
\code{@sequences} slot to return.}

\item{as.haplotypes}{return sequences as haplotypes? If \code{TRUE}, contents of 
\code{@sequences} slot are returned. If \code{FALSE}, one sequence per 
individual is returned.}

\item{i, j, k}{subsetting slots for individuals (\code{i}), loci (\code{j}),
or strata (\code{k}). See Details for more information.}

\item{quiet}{suppress warnings about unmatched requested individuals, loci, 
or strata?}

\item{drop}{if \code{TRUE} the return object will have unused sequences removed.}
}
\value{
\describe{
  \item{nInd}{number of individuals}
  \item{nLoc}{number of loci}
  \item{nStrata}{number of strata}
  \item{indNames}{vector of individual/sample names}
  \item{locNames}{vector of locus names}
  \item{strataNames}{vector of strata names for current scheme}
  \item{ploidy}{number of alleles at each locus}
  \item{other}{contents of \code{@other} slot}
  \item{strata}{return or modify the current stratification}
  \item{schemes}{return or modify the current stratification schemes}
  \item{alleleNames}{return a list of alleles at each locus}
  \item{sequences}{return the \linkS4class{multidna} object in the 
    \code{@sequences} slot. See \code{\link[apex]{getSequences}} to 
    extract individual genes or sequences from this object}
  \item{description}{return the object's description}
}
}
\description{
Accessors for slots in \linkS4class{gtypes} objects.
}
\details{
Indexing a \code{gtypes} object with integers, characters, or logicals with 
  the \code{[} operator follows the same rules as normal indexing in R. The 
  order that individuals, loci, and strata are chosen in the order 
  returned by \code{indNames}, \code{locNames}, and \code{strataNames} 
  respectively. If unstratified samples are present, they can be selected as
  a group either by including \code{NA} in the character or numeric vector of the 
  \code{k} slot, or by providing a logical vector based on \code{is.na(strata(g))} 
  to the \code{i} slot.
}
\examples{
#--- create a diploid (microsatellite) gtypes object
data(msats.g)
msats.g <- stratify(msats.g, "fine")

nStrata(msats.g)
strataNames(msats.g)
nLoc(msats.g)
locNames(msats.g)

# reassign all samples to two randomly chosen strata
strata(msats.g) <- sample(c("A", "B"), nInd(msats.g), rep = TRUE)
msats.g


#--- a sequence example
library(ape)
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
wood.g <- sequence2gtypes(x)
strata(wood.g) <- sample(c("A", "B"), nInd(wood.g), rep = TRUE)
wood.g

# get the multidna sequence object
multi.seqs <- sequences(wood.g)
class(multi.seqs) # "multidna"

# get a list of DNAbin objects
library(apex)
dnabin.list <- getSequences(multi.seqs)
class(dnabin.list) # "list"

# get a DNAbin object of the first locus
dnabin.1 <- getSequences(multi.seqs, locNames(wood.g)[1])
class(dnabin.1) # "DNAbin"

# NOTE: The default to the 'simplify' argument in 'getSequences' is TRUE, 
#   so if there is only one locus, 'getSequences' will return a DNAbin object
#   rather than a single element list unless 'simplify = FALSE':
gene1 <- wood.g[, "gene1", ]
gene1.dnabin <- getSequences(sequences(gene1))
class(gene1.dnabin) # "DNAbin"

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
