% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.gtypes.R
\docType{methods}
\name{as.data.frame.gtypes}
\alias{as.data.frame.gtypes}
\alias{as.data.frame,gtypes-method}
\alias{as.data.frame}
\title{Convert \code{gtypes} To \code{data.frame}}
\usage{
\S4method{as.data.frame}{gtypes}(x, one.col = FALSE, sep = "/",
  ids = TRUE, strata = TRUE, sort.alleles = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{gtypes} object.}

\item{one.col}{logical. If \code{TRUE}, then result has one column per 
locus.}

\item{sep}{character to use to separate alleles if \code{one.col} is 
\code{TRUE}.}

\item{ids}{logical. include a column for individual identifiers (\code{ids})?}

\item{strata}{logical. include a column for current statification (\code{strata})?}

\item{sort.alleles}{logical. for non-haploid objects, should alleles be sorted 
in genotypes or left in original order? (only takes affect if \code{one.col = TRUE})}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
A \code{data.frame} with one row per sample.
}
\description{
Create a data.frame from a \linkS4class{gtypes} object.
}
\examples{
data(msats.g)

# with defaults (alleles in multiple columns, with ids and stratification)
df <- as.data.frame(msats.g)
str(df)

# one column per locus
onecol.df <- as.data.frame(msats.g, one.col = TRUE)
str(onecol.df)

# just the genotypes
genotypes.df <- as.data.frame(msats.g, one.col = TRUE, ids = FALSE, strata = FALSE)
str(genotypes.df)

}
\seealso{
\link{df2gtypes} \link[strataG]{as.matrix} \link[strataG]{as.array}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
