% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/is.ti.tv.R, R/ti.tv.ratio.R
\name{is.ti.tv}
\alias{is.ti.tv}
\alias{ti.tv.ratio}
\title{Transition / Transversion Ratio}
\usage{
is.ti.tv(b1, b2, sub.type)

ti.tv.ratio(dna.seq)
}
\arguments{
\item{b1,b2}{two bases to be compared.}

\item{sub.type}{type of substitution to check: 'ti' for transition, 'tv' for transversion.}

\item{dna.seq}{sequence of DNA.}
}
\value{
For \code{ti.tv.ratio}, a vector providing: \cr
\tabular{ll}{
  \code{Ti} \tab the number of transitions.\cr
  \code{Tv} \tab the number of transversions.\cr
  \code{Ti.Tv.ratio} \tab the transition/transversion ratio.\cr
}
For \code{is.ti.tv} a logical identifying whether the \code{b1} to \code{b2} is a \code{sub.type} substitution
}
\description{
Calculate transition/transversion ratio. Test substitution type of two bases.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

