% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/phase.filter.R, R/phase.posterior.R, R/phase.read.pair.R, R/phase.read.sample.R, R/phase.run.R, R/phase.write.R
\name{phase.filter}
\alias{phase}
\alias{phase.filter}
\alias{phase.posterior}
\alias{phase.read.pair}
\alias{phase.read.sample}
\alias{phase.run}
\alias{phase.write}
\title{PHASE}
\usage{
phase.filter(ph.res, thresh = 0.5, keep.missing = TRUE)

phase.posterior(ph.res, keep.missing = TRUE)

phase.read.pair(out.file)

phase.read.sample(out.file, type)

phase.run(g, loci, positions = NULL, type = NULL, num.iter = 1e+05,
  thinning = 100, burnin = 1e+05, model = "new", ran.seed = NULL,
  final.run.factor = NULL, save.posterior = FALSE, in.file = "phase_in",
  out.file = "phase_out", delete.files = TRUE, num.cores = 1)

phase.write(g, loci, positions = NULL, type = rep("S", length(loci)),
  in.file = "phase_in")
}
\arguments{
\item{ph.res}{result from \code{phase.run}.}

\item{thresh}{minimum probability for a genotype to be selected (0.5 - 1).}

\item{keep.missing}{logical. T = keep missing data from original data set. F = Use estimated genotypes from PHASE.}

\item{out.file}{name to use for PHASE output files.}

\item{type}{type of each locus.}

\item{g}{a \code{\link{gtypes}} object.}

\item{loci}{vector of names of locus in 'gtypes' that are to be phased.}

\item{positions}{position along chromosome of each locus.}

\item{num.iter}{number of PHASE MCMC iterations.}

\item{thinning}{number of PHASE MCMC iterations to thin by.}

\item{burnin}{number of PHASE MCMC iterations for burnin.}

\item{model}{PHASE model type.}

\item{ran.seed}{PHASE random number seed.}

\item{final.run.factor}{optional.}

\item{save.posterior}{logical. Save posterior sample in output list?}

\item{in.file}{name to use for PHASE input file.}

\item{delete.files}{logical. Delete PHASE input and output files when done?}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}
}
\value{
\describe{
 \item{phase.run}{a list containing:
   \tabular{ll}{
     \code{locus.name} \tab new locus name, which is a combination of loci in group.\cr
     \code{gtype.probs} \tab a data.frame listing the estimated genotype for every sample along with probability.\cr
     \code{orig.gtypes} \tab the original gtypes object for the composite loci.\cr
     \code{posterior} \tab a list of \code{num.iter} data.frames representing posterior sample of genotypes for each sample.\cr
   }}
 \item{phase.write}{a list with the input filename and the \code{\link{gtypes}} object used.}
 \item{phase.read.pair}{a data.frame of genotype probabilities.}
 \item{phase.read.sample}{a list of data.frames representing the posterior sample of genotypes for one set of loci for each sample.}
 \item{phase.filter}{a matrix of genotypes for each sample.}
 \item{phase.posterior}{a list of data.frames representing the posterior sample of all genotypes for each sample.}
}
}
\description{
Run PHASE to estimate the phase of loci in diploid data.
}
\details{
\tabular{ll}{
  \code{phase.run} \tab runs PHASE assuming that the executable is installed properly and available on the command line.\cr
  \code{phase.write} \tab writes a PHASE formatted file.\cr
  \code{phase.read.pair} \tab reads the '_pair' output file.\cr
  \code{phase.read.sample} \tab reads the '_sample' output file.\cr
  \code{phase.filter} \tab filters the result from \code{phase.run} to extract one genotype for each sample.\cr
  \code{phase.posterior} \tab create a data.frame all genotypes for each posterior sample.\cr
}
}
\note{
Assumes that the the command line version of PHASE is properly installed and available on the command line,
  so it is executable from any directory. On PC's, this requires having it in a folder in
  the PATH environmental variable. On Macs, the executable should be installed in a folder
  like \code{/usr/local/bin}
}
\examples{
\dontrun{
data(bowhead.snps)
data(bowhead.snp.position)
snps <- gtypes(bowhead.snps, description = "Bowhead SNP example")
summary(snps)

# Run PHASE on all data
phase.results <- phase.run(snps, bowhead.snp.position, num.iter = 100, save.posterior = FALSE)

# Filter phase results
filtered.results <- phase.filter(phase.results, thresh = 0.5)

# Convert phased genotypes to gtypes
ids <- rownames(filtered.results)
strata <- bowhead.snps$Stock[match(ids, bowhead.snps$LABID)]
filtered.results <- cbind(id = ids, strata = strata, filtered.results)
phased.snps <- gtypes(filtered.results, description = "Bowhead phased SNPs")
summary(phased.snps)
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Stephens, M., and Donnelly, P. (2003). A comparison of Bayesian methods for haplotype reconstruction from
  population genotype data. American Journal of Human Genetics 73:1162-1169.
  Available at: \url{http://stephenslab.uchicago.edu/software.html#phase}
}

