% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/check.genotypes.R
\name{check.genotypes}
\alias{check.genotypes}
\title{Run All Genotype QA/QC Tests}
\usage{
check.genotypes(x, label, num.shared = 0.8, exclude.num = 1,
  min.hwe.samples = 5, alpha = 0.05, num.cores = 1)
}
\arguments{
\item{x}{either a .csv file or data.frame with genotype data. First column has IDs,
second column has stratifications, third column to end has genotypes with two columns per locus.}

\item{label}{label for output folder and prefix for files.}

\item{num.shared}{either number of loci or percentage of loci two individuals must share to
be considered duplicate individuals.}

\item{exclude.num,min.hwe.samples,alpha}{parameters for \code{\link[strataG]{jack.hwe}}
and \code{\link[strataG]{jack.influential}}.}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}
}
\value{
Nothing is returned, but outputs are placed in a folder specified by \code{label}.
}
\description{
Produces by-locus and by-sample summaries, checks for duplicates,
and runs Hardy-Weinberg Jackknife test.
}
\note{
Requires that GENEPOP is installed on the system and accessible from the command line.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

