% Generated by roxygen2 (4.0.2): do not edit by hand
\name{hwe.genepop}
\alias{hwe}
\alias{hwe.genepop}
\title{Hardy-Weinberg Equilibrium}
\usage{
hwe.genepop(g, show.output = FALSE, delete.files = TRUE,
  label = "HWE.genepop", ...)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{show.output}{logical. Show output from GENEPOP?}

\item{delete.files}{logical. Delete GENEPOP files when done?}

\item{label}{character string to use to label GENEPOP files.}

\item{...}{arguments to be passed to \code{\link{genepop.run}}.}
}
\value{
a vector of MCMC p-values for each locus.
}
\description{
Calculate Hardy-Weinberg equilibrium p-values using GENEPOP.
}
\note{
Assumes that the the command line version of GENEPOP v.4 is properly installed and available on the command line,
  so it is executable from any directory. On PC's, this requires having it in a folder in
  the PATH environmental variable. On Macs, the executable should be installed in a folder
  like \code{/usr/local/bin}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{genepop.run}}
}

