% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{not.colnames}
\alias{not.colnames}
\title{Identify Elements That are Not Colnames}
\usage{
not.colnames(x, nm)
}
\arguments{
\item{x}{object with a colnames attribute}

\item{nm}{character vector specifying the elements to test as colnames of \code{x}.}
}
\value{
character vector containing the elements of \code{nm} that are not colnames
of \code{x}.
}
\description{
\code{not.colnames} identifies which elements from \code{nm} are not colnames of \code{x}.
If all elements are colnames, then a character vector of length 0 is returned.
}
\examples{
not.colnames(x = as.matrix(mtcars), nm = c("MPG","mpg"))
}
