% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{e2l}
\alias{e2l}
\title{Environment to List}
\usage{
e2l(
  e = sys.frame(),
  val,
  pat = FALSE,
  not = FALSE,
  fixed = FALSE,
  sorted = FALSE,
  check = TRUE
)
}
\arguments{
\item{e}{environment to pull the objects from. Default is the global environment.}

\item{val}{character vector specifying which objects from \code{e} will be extracted.
If \code{pat} = FALSE (default), then \code{val} can have length > 1, and exact
matching will be done via \code{is.element} (essentially \code{match}). If
\code{pat} = TRUE, then \code{val} has to be a character vector of length 1 and
partial matching will be done via \code{grepl} with the option of regular expressions
if \code{fixed} = FALSE (default).}

\item{pat}{logical vector of length 1 specifying whether \code{val} should refer to
exact matching (FALSE) via \code{is.element} (essentially \code{match}) or partial
matching (TRUE) and/or use of regular expressions via \code{grepl}. See details
for a brief description of some common symbols and \code{help(regex)} for more.}

\item{not}{logical vector of length 1 specifying whether \code{val} indicates
values that should be retained (FALSE) or removed (TRUE).}

\item{fixed}{logical vector of length 1 specifying whether \code{val} refers to
values as is (TRUE) or a regular expression (FALSE). Only used if \code{pat} = TRUE.}

\item{sorted}{logical vector of length 1 specifying whether the objects should
be sorted alphanumerically. If FALSE, the objects are usually in the order they
were initially created, but not always (see \code{help(objects)}).}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{e} is an environment.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
list with object contents from environment \code{e} with names as the
object names.
}
\description{
\code{e2l} converts an environment to a list. The function assumes you don't
want *all* objects in an environment and uses \code{pick} to determine which
objects you want included. If you want all objects in an environment, then use
\code{grab(x = objects(envir, all.names = TRUE), envir)}.
}
\examples{
model_1 <- lm(v2frm(names(attitude)), data = attitude)
model_2 <- lm(v2frm(names(mtcars)), data = mtcars)
model_3 <- lm(v2frm(names(airquality)), data = airquality)
e2l(val = "model_", pat = TRUE)
}
