% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{dimlabels}
\alias{dimlabels}
\title{Dimension labels (i.e., names of dimnames)}
\usage{
dimlabels(x)
}
\arguments{
\item{x}{object that has dimensions (e.g., array).}
}
\value{
character vector of length  = \code{ndim(x)} specifying the dimension
labels (i.e., names of dimnames) of \code{x}. If \code{x} does not have any
dimensions, or has dimensions but no dimension labels, then NULL is returned.
}
\description{
\code{dimlabels} returns the the dimension labels (i.e., names of dimnames)
of an object. This is most useful for arrays, which can have anywhere from 1
to 1000+ dimensions.
}
\details{
\code{dimlabels} is a very simple function that is simply \code{names(dimnames(x))}.
}
\examples{
dimlabels(state.region)
dimlabels(attitude)
dimlabels(HairEyeColor)
}
