% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{d2v}
\alias{d2v}
\title{Data-Frame to (Atomic) Vector}
\usage{
d2v(
  d,
  along = 2,
  use.dimnames = TRUE,
  sep = "_",
  fct = "chr",
  chr = "chr",
  lgl = "int",
  order.lvl = "alphanum",
  decreasing = FALSE,
  na.lvl = FALSE,
  check = TRUE
)
}
\arguments{
\item{d}{data.frame.}

\item{along}{numeric vector of length one that is equal to either 1 or 2.
1 means that \code{d} is split along rows (i.e., dimension 1) and then concatenated.
2 means that \code{d} is split along columns (i.e., dimension 2) and then concatenated.}

\item{use.dimnames}{logical vector of length 1 that specifies whether the dimnames
of \code{d} should be used to create the names for the returned vector. If FALSE,
the returned vector will have NULL names. If TRUE, see details of \code{m2v}.}

\item{sep}{character vector of length 1 specifying the string that will separate
the rownames and colnames in the naming scheme of the returned vector. Note, \code{sep}
is not used if \code{use.dimnames} = FALSE.}

\item{fct}{character vector of length 1 specifying what factors should be converted
to. There are three options: 1) "chr" for converting to character vectors (i.e.,
factor labels), 2) "int" for converting to integer vectors (i.e., factor codes),
or 3) "fct" for keeping the factor as is without any changes.}

\item{chr}{character vector of length 1 specifying what character vectors should
be converted to. There are three options: 1) "fct" for converting to factors (i.e.,
elements will be factor labels), 2) "int" for converting to integer vectors (i.e.,
factor codes after first converting to a factor), or 3) "chr" for keeping the
character vectors as is without any changes.}

\item{lgl}{character vector of length 1 specifying what logical vectors should
be converted to. There are four options: 1) "fct" for converting to factors (i.e.,
"TRUE" and "FALSE" will be factor labels), 2) "chr" for converting to character
vectors (i.e., elements will be "TRUE" and "FALSE"), 3) "int" for converting to
integer vectors (i.e., TRUE = 1; FALSE = 0), and 4) "lgl" for keeping the logical
vectors as is without any changes.}

\item{order.lvl}{character vector of length 1 specifying how you want to order
the levels of the factor. The options are "alphanum", which sorts the levels
alphanumerically (with NA last); "position", which sorts the levels by the position
the level first appears; "frequency", which sorts the levels by their frequency.
If any frequencies are tied, then the ties are sorted alphanumerically (with NA last).}

\item{decreasing}{logical vector of length 1 specifying whether the ordering of the
levels should be decreasing (TRUE) rather than increasing (FALSE).}

\item{na.lvl}{logical vector of length 1 specifying if NA should be considered a level.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{d} is a data.frame.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(atomic) vector with elements from \code{d}. If \code{d} had one row,
then the names of the return object are \code{names(d)}. If \code{d} has one
column, then the names of the return object are \code{row.names(d)}.
}
\description{
\code{d2v} converts a data.frame to a matrix. The user can specify how to convert
factors, character vectors, and integer vectors in the data.frame through the
internal use of the \code{d2d} function. After the call to \code{d2d}, the
data.frame is simplied to an atomic vector, which will return a vector of the most
complex typeof of any column in the data.frame (most complex to least complex:
character, double, integer, logical). Therefore, if any factors or character
vectors are left in the data.frame, it will return a character vector. On the
other side of things, if all columns in the data.frame are logical, then it will
return a logical vector. However, if every column in the data.frame is logical
except for one factor or character vector, then it will return a character vector.
}
\examples{
# general data.frame
d2v(mtcars) # default
d2v(d = mtcars, along = 1) # concatenate along rows
d2v(d = mtcars, sep = ".") # change the sep of the rownames(d) and colnames(d)
d2v(d = mtcars, use.dimnames = FALSE) # return object has no names
# one row/column data.frame
one_row <- mtcars[1,, drop = FALSE]
d2v(one_row)
one_col <- mtcars[, 1, drop = FALSE]
d2v(one_col)
one_all <- mtcars[1,1, drop = FALSE]
d2v(one_all)
d2v(one_all, use.dimnames = FALSE)
}
