# "stppSim"

Spatial and Temporal Point Patterns Simulation for Social and Life Science Research

## Description

Generates artificial spatiotemporal (ST) point patterns through the integration of microsimulation and agent-based models. Allows a user to define the behaviours of a set of 'walkers' (agents, objects, persons, etc.) whose interactions with the spatial (landscape) and the temporal domains produce new point events. The resulting ST patterns from the point cloud can be measured and utilized for spatial and/or temporal model testings and evaluations. Application: With increasingly limited availability of fine-grained spatially and temporally stamped point data, the package provides an alternative source of data for a wide range of fields in social and life sciences.

## Installation from `CRAN`

From an R console, type:

```{r}
#install.packages("stppSim")
library(stppSim)

```

To install the developmental version of the package, type:
`remotes::install_github("MAnalytics/stppSim")`. (Note: `remotes` is an extra package that needed to be installed prior to the running of this code). 

Please, report any installation problems in the issues.
