% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly_tester.R
\name{poly_tester}
\alias{poly_tester}
\title{Geometry and Coordinate
Reference System test of a polygon}
\usage{
poly_tester(poly)
}
\arguments{
\item{poly}{(as \code{spatialPolygons}, \code{spatialPolygonDataFrames}, or
\verb{simple features}). A spatial polygon object.}
}
\value{
Returns error messages, or mute
}
\description{
Tests whether a polygon
has the correct geometry,
namely; \code{S4} or \code{sf}. Also, tests
that there is a valid projection attached to
the polygon.
}
\details{
Returns an error message if
the polygon is not in the
correct geometry or CRS.
}
\examples{
#load boundary of Camden
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
boundary = camden$boundary # get boundary
poly_tester(poly=boundary)
}
