% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_osrm.R
\name{route_osrm}
\alias{route_osrm}
\title{Plan routes on the transport network using the OSRM server}
\usage{
route_osrm(
  from,
  to,
  osrm.server = "https://routing.openstreetmap.de/",
  osrm.profile = "foot"
)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{osrm.server}{The base URL of the routing server.
getOption("osrm.server") by default.}

\item{osrm.profile}{The routing profile to use, e.g. "car", "bike" or "foot"
(when using the routing.openstreetmap.de test server).
getOption("osrm.profile") by default.}

\item{profile}{Which routing profile to use? One of "foot" (default)
"bike" or "car" for the default open server.}
}
\description{
This function is a simplified and (because it uses GeoJSON not binary polyline format)
slower R interface to OSRM routing services compared with the excellent
\code{\link[osrm:osrmRoute]{osrm::osrmRoute()}} function (which can be used via the \code{\link[=route]{route()}}) function.
}
\examples{
\donttest{
# Examples no longer working due to API being down
# l1 = od_data_lines[49, ]
# l1m = od_coords(l1)
# from = l1m[, 1:2]
# to = l1m[, 3:4]
# if(curl::has_internet()) {
# r_foot = route_osrm(from, to)
# r_bike = route_osrm(from, to, osrm.profile = "bike")
# r_car = route_osrm(from, to, osrm.profile = "car")
# plot(r_foot$geometry, lwd = 9, col = "grey")
# plot(r_bike, col = "blue", add = TRUE)
# plot(r_car, col = "red", add = TRUE)
# }
}
}
\seealso{
Other routes: 
\code{\link{route_dodgr}()},
\code{\link{route}()}
}
\concept{routes}
