% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_wind_code.R
\name{calc_and_summarize_grid_wind}
\alias{calc_and_summarize_grid_wind}
\title{Calculate and summarize grid winds}
\usage{
calc_and_summarize_grid_wind(
  grid_point = stormwindmodel::county_points[1, ],
  with_wind_radii = add_wind_radii(),
  tint = 0.25,
  gust_duration_cut = 20,
  sust_duration_cut = 20
)
}
\arguments{
\item{grid_point}{A one-row dataframe with the grid id, latitude, and
longitude for a single location for which you want to model winds.}

\item{with_wind_radii}{A dataframe of storm tracks, including inputs and
parameters for the Willoughby wind model, as created by
\code{\link{add_wind_radii}}.}

\item{tint}{Interval (in hours) to which to interpolate the tracks. The
default is 0.25 (i.e., 15 minutes).}

\item{gust_duration_cut}{The wind speed, in meters per second, to use as a
cutoff point for determining the duration of gust winds. The function
will calculate the minutes during the storm when surface-level gust winds
were above this speed at the location.}

\item{sust_duration_cut}{The wind speed, in meters per second, to use as a
cutoff point for determining the duration of gust winds. The function
will calculate the minutes during the storm when surface-level gust winds
were above this speed at the location.}
}
\value{
Returns a one-row matrix with wind characteristics for a single
   location. The wind characteristics given are:
   \itemize{
     \item{\code{vmax_gust}: Maximum value of surface-level (10 meters)
       gust winds, in meters per second, over the length of the
       storm at the given location}
     \item{\code{vmax_sust}: Maximum value of surface-level (10 meters)
       sustained winds, in meters per second, over the length of the
       storm at the given location}
     \item{\code{gust_dur}: Length of time, in minutes, that
       surface-level gust winds were above a specified speed (default is
       20 m / s)}
     \item{\code{sust_dur}: Length of time, in minutes, that
       surface-level sustained winds were above a specified speed (default is
       20 m / s)}
   }
}
\description{
This function combines the \code{\link{calc_grid_wind}} and
\code{\link{summarize_grid_wind}} functions so they can be run jointly in
the overall \code{\link{get_grid_winds}} function. This function calculates
wind characteristics at just one location. Within the package, the function
used within another function (\code{\link{get_grid_winds}}) to model wind speeds at
all grid locations.
}
\examples{
\dontrun{
library(dplyr)
data(county_points)
data("floyd_tracks")
full_track <- create_full_track(hurr_track = floyd_tracks, tint = 0.25)
with_wind_radii <- add_wind_radii(full_track = full_track)
grid_point <- county_points \%>\% filter(gridid == "37055")
grid_wind_summary <- calc_and_summarize_grid_wind(grid_point = grid_point,
   with_wind_radii = with_wind_radii, gust_duration_cut = 15,
   sust_duration_cut = 15)
}

}
