% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_association}
\alias{c_association}
\title{c-association
calculates the c-association based on the maximal information coefficient 
We define c-association as the aggregated association between any two columns in confs}
\usage{
c_association(
  confs,
  aggr = max,
  alpha = 0.6,
  C = 15,
  var.thr = 1e-05,
  zeta = NULL
)
}
\arguments{
\item{confs}{a numeric matrix or data frame}

\item{aggr}{the aggregation function for configurations of more than two dimensions. Defaults to max.}

\item{alpha}{an optional number of cells allowed in the X-by-Y search-grid. Default value is 0.6}

\item{C}{an optional number determining the starting point of the X-by-Y search-grid. When trying to partition the x-axis into X columns, the algorithm will start with at most C X clumps. Default value is 15.}

\item{var.thr}{minimum value allowed for the variance of the input variables, since mine can not be computed in case of variance close to 0. Default value is 1e-5.}

\item{zeta}{integer in [0,1] (?).  If NULL (default) it is set to 1-MIC. It can be set to zero for noiseless functions, but the default choice is the most appropriate parametrization for general cases (as stated in Reshef et al). It provides robustness.}
}
\value{
a numeric value; association (aggregated maximal information coefficient MIC, see \code{\link[minerva]{mine}})
}
\description{
c-association
calculates the c-association based on the maximal information coefficient 
We define c-association as the aggregated association between any two columns in confs
}
\examples{
x<-seq(-3,3,length.out=200)
y<-sqrt(3^2-x^2)
z<- sin(y-x)
confs<-cbind(x,y,z)
c_association(confs)
}
