% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/returnStateEvents.R
\name{returnStateEvents}
\alias{returnStateEvents}
\title{Return State Events}
\usage{
returnStateEvents(dt)
}
\arguments{
\item{dt}{data.table updated with stop and move events from
\code{\link{stopFinder}}}
}
\value{
data.table with one line per stop/move event, annotated with columns
state_id, state, begin_time, end_time and n_locations. Move events contain
information on the raw_travel_dist and a move_id. Stop events have values
for columns meanlat and meanlon, which are respectively the mean latitude
and longitude of locations occurring during the stop.
}
\description{
Given a data.table updated with stop and move events from
\code{\link{stopFinder}}, returns data aggregated to the event level.
}
\examples{
library(data.table)
data(loc_data_2019); setDT(loc_data_2019)
stopFinder(loc_data_2019, thetaD = 200, thetaT = 300)
returnStateEvents(loc_data_2019)
}
