% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{createForestModel}
\alias{createForestModel}
\title{Create a forest model object}
\usage{
createForestModel(forest_dataset, forest_model_config, global_model_config)
}
\arguments{
\item{forest_dataset}{ForestDataset object, used to initialize forest sampling data structures}

\item{forest_model_config}{ForestModelConfig object containing forest model parameters and settings}

\item{global_model_config}{GlobalModelConfig object containing global model parameters and settings}
}
\value{
\code{ForestModel} object
}
\description{
Create a forest model object
}
\examples{
num_trees <- 100
n <- 100
p <- 10
alpha <- 0.95
beta <- 2.0
min_samples_leaf <- 2
max_depth <- 10
feature_types <- as.integer(rep(0, p))
X <- matrix(runif(n*p), ncol = p)
forest_dataset <- createForestDataset(X)
forest_model_config <- createForestModelConfig(feature_types=feature_types, 
                                               num_trees=num_trees, num_features=p, 
                                               num_observations=n, alpha=alpha, beta=beta, 
                                               min_samples_leaf=min_samples_leaf, 
                                               max_depth=max_depth, leaf_model_type=1)
global_model_config <- createGlobalModelConfig(global_error_variance=1.0)
forest_model <- createForestModel(forest_dataset, forest_model_config, global_model_config)
}
