% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCorpus.R
\name{readLdac}
\alias{readLdac}
\title{Read in a .ldac Formatted File}
\usage{
readLdac(filename)
}
\arguments{
\item{filename}{An input file or filepath to be processed}
}
\value{
\item{documents}{A documents object in our format}
}
\description{
Read in a term document matrix in the .ldac sparse matrix format popularized
by David Blei's C code implementation of lda.
}
\details{
\code{ldac} expects a file name or path that contains a file in Blei's LDA-C
format. From his ReadMe: "The data is a file where each line is of the form:

[M] [term_1]:[count] [term_2]:[count] ...  [term_N]:[count]

where [M] is the number of unique terms in the document, and the [count]
associated with each term is how many times that term appeared in the
document.  Note that [term_1] is an integer which indexes the term; it is
not a string."

Because R indexes from one, the values of the term indices are incremented
by one on import.
}
\seealso{
\code{\link{textProcessor}}, \code{\link{prepDocuments}} \code{\link{readCorpus}}
}
