% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csb_load_variables.R
\name{csb_load_variables}
\alias{csb_load_variables}
\title{Load CSB Variable Definitions}
\usage{
csb_load_variables(tidy = TRUE)
}
\arguments{
\item{tidy}{A logical scalar; if \code{TRUE}, variable names will be converted to
lower case and reordered. Two variables with incomplete data - problem city
(\code{PROBCITY}) and problem zip code (\code{PROBZIP}) - are dropped to limit
use of memory. This mirrors the functionality of \link{csb_get_data}.}
}
\value{
A tibble containing variable names and definitions.
}
\description{
Provides direct access to the CSB's variable definitions, which
    are available for download from the City of St. Louis's
    \href{https://www.stlouis-mo.gov/data/}{open data} site.
}
\examples{
csb_load_variables()
csb_load_variables(tidy = FALSE)

}
\seealso{
\href{https://www.stlouis-mo.gov/data/}{City of St. Louis Open Data},
    \href{https://www.stlouis-mo.gov/data/service-requests.cfm}{City of St. Louis CSB Data}
}
