% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_change-functions.R
\name{growth}
\alias{growth}
\title{Population growth}
\usage{
growth(
  transition_matrix,
  global_stochasticity = 0,
  local_stochasticity = 0,
  transition_function = NULL,
  transition_order = c("fecundity", "survival"),
  two_sex = FALSE
)
}
\arguments{
\item{transition_matrix}{A symmetrical age-based (Leslie) or stage-based (Lefkovitch)
population structure matrix.}

\item{global_stochasticity, local_stochasticity}{Either scalar values or
matrices (with the same dimension as \code{transition_matrix}) specifying
the variability in the transition matrix either for populations in all grid
cells (\code{global_stochasticity}) or for each grid cell population
separately (\code{local_stochasticity}). Values supplied here are the
standard deviation of a truncated normal distribution where the mean is the
value supplied in the transition matrix.}

\item{transition_function}{A function to specify or modify life-stage transitions
at each timestep. See \link[steps]{transition_function}.}

\item{transition_order}{Order of transitions performed in growth function. This behaviour
is only applied when demographic stochasticity is set to "full" (default) and transitions
are applied sequentially. By default "fecundity" is performed first (calculating the
number of new individuals to be added to the populations), then "survival" is applied.
The final population is the sum of these. Users should be cautious of specifying
"survival" to be performed first as typically survival of reproductive stages will already
be accounted for in the fecundity values of the transition matrix.}

\item{two_sex}{Does the transition matrix include life stages for two sexes (i.e. male and
female)? Default is FALSE which assumes a single sex matrix (e.g. females only).}
}
\description{
This function applies negative or positive growth to the population using matrix
multiplication. Stochasticity can be added to cell-based transition matrices or globally.
Users can also specify a built-in or custom function to modify the transition matrices
throughout a simulation. Please see the tutorial vignette titled "Creating custom
*steps* functions" for information on how to write custom functions for use in simulations.
}
\examples{

# Example of a growth function that changes the populations based on a transition matrix that
# is subject to global stochasticity. 

\dontrun{
stoch_growth <- growth(transition_matrix = egk_mat, global_stochasticity = egk_mat_stoch)

ls <- landscape(population = egk_pop, suitability = NULL, carrying_capacity = NULL)

pd <- population_dynamics(change = stoch_growth)

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
