% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_stdmod_lavaan.R
\name{confint.stdmod_lavaan}
\alias{confint.stdmod_lavaan}
\title{Confidence Intervals for a 'stdmod_lavaan' Class Object}
\usage{
\method{confint}{stdmod_lavaan}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The output of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}}.}

\item{parm}{Ignored. Always return the bootstrap confidence interval
of the standardized moderation effect.}

\item{level}{The level of confidence, default is .95, returning the
95\% confidence interval.}

\item{...}{Additional arguments. Ignored by the function.}
}
\value{
A one-row matrix of the confidence intervals.
}
\description{
Return the confidence interval of the standardized
moderation effect
in the output of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}}.
}
\details{
If bootstrapping is used to form the confidence interval by
\code{\link[=stdmod_lavaan]{stdmod_lavaan()}},
users can request the percentile confidence interval of
using the stored bootstrap estimate.
}
\examples{

# Load a test data of 500 cases
dat <- test_mod1
library(lavaan)

mod <-
"
med ~ iv + mod + iv:mod + cov1
dv ~ med + cov2
"
fit <- sem(mod, dat)
coef(fit)

# Compute the standardized moderation effect and
# its confidence interval based on nonparametric bootstrapping
set.seed(8479075)
system.time(out_boot <- stdmod_lavaan(fit = fit,
                                      x = "iv",
                                      y = "med",
                                      w = "mod",
                                      x_w = "iv:mod",
                                      boot_ci = TRUE,
                                      R = 50))
# In real analysis, R should be at least 2000.
confint(out_boot)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
