% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fsqca_sim_inclcut.R
\name{fsqca_sim_inclcut}
\alias{fsqca_sim_inclcut}
\title{fsQCA Sufficiency Inclusion Score Simulation}
\usage{
fsqca_sim_inclcut(data, outcome, conditions, min.incl.cut,
max.incl.cut, n.cut, reps, verbose, ...)
}
\arguments{
\item{data}{a data frame}

\item{outcome}{a character string or column index indicating the outcome variable}

\item{conditions}{optional character vector or vector of column indices indicating explanatory variables}

\item{min.incl.cut}{numeric lower bound for sampling of sufficiency inclusion scores}

\item{max.incl.cut}{numeric upper bound for sampling of sufficiency inclusion scores}

\item{n.cut}{minimum frequency threshold}

\item{reps}{number of sufficiency inclusion score pairs to be sampled}

\item{verbose}{logical; if TRUE, prints additional execution information}

\item{...}{optional arguments passed to \code{eqmcc()}}
}
\value{
Returns adata frame containing solutions produced for each set of sampled parameter values
}
\description{
\code{fsqca_sim_inclcut} returns QCA results for a range of minimum frequency thresholds across
an arbitrarily large set of sufficiency inclusion scores
}
\examples{
# Load data
data(hh)

# Remove case indicator
hh<-hh[,-which(colnames(hh)=="Country")]

# Run function
a<-fsqca_sim_inclcut(data = hh, outcome = "success", n.cut=2)

# Get table of solutions (note: truncated to first 50 rows)
a[1:50,]

# Increase the number of replications
#'a<-fsqca_sim(data = hh, outcome = "success", reps=1000, plot = TRUE)
}

