% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eqmcc_options.R
\name{eqmcc_options}
\alias{eqmcc_options}
\title{Simulations using \code{eqmcc()}}
\usage{
eqmcc_options(data, eqmcc.options.list, verbose)
}
\arguments{
\item{data}{a data frame}

\item{eqmcc.options.list}{a named list containing \code{eqmcc()} arguments
and the values with which they should be simulated; list should be initially
produced by a call to \code{eqmcc_args()}}

\item{verbose}{logical; if TRUE, will print extra execution informaton}
}
\value{
Returns a named list containing the following elements:

\item{\code{opts}}{a data frame containing the parameter values used for each execution}
\item{\code{results}}{a list of \code{eqmcc()} solutions}
}
\description{
\code{eqmcc_options} repeatedly executes the \code{eqmcc()} function
over a number of different argument values and returns its solutions
}
\examples{
# Load data
data(hicks_20)

# Generate list of eqmcc arguments
arglist<-eqmcc_args()

# Specify values for execution
arglist$outcome<-"CON"
arglist$n.cut<-1:5
arglist$include<-c("1", "?", paste("1", "?", sep=","))

# Run execution
a<-eqmcc_options(data = hicks_20[,-1], eqmcc.options.list = arglist)

# Get data frame of parameter values
a$opts

# Get the solutions for parameter specifications in row 6
a$opts[6,]
a$results[[6]]

# Load data
data(hh)

# Generate list of eqmcc arguments
arglist<-eqmcc_args()

# Specify values for execution
arglist$outcome<-"success"
arglist$incl.cut1<-seq(from = 0.5, to = 1, by = 0.05)
arglist$n.cut<-1:5
arglist$include<-c("1", "?", paste("1", "?", sep=","))

# Run execution
a<-eqmcc_options(data = hh[,-1], eqmcc.options.list = arglist)

# Get data frame of parameter values
a$opts

# Get the solutions for parameter specifications in row 27
a$opts[27,]
a$results[[27]]
}

