% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_effsize_ci.R
\name{robcor_ci}
\alias{robcor_ci}
\title{Robust correlation coefficient and its confidence interval}
\usage{
robcor_ci(
  data,
  x,
  y,
  beta = 0.1,
  nboot = 100,
  conf.level = 0.95,
  conf.type = "norm",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A vector containing the explanatory variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{beta}{bending constant (Default: \code{0.1}). For more, see \code{?WRS2::pbcor}.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{...}{Currently ignored.}
}
\value{
A tibble with percentage bend correlation coefficient, along with its
confidence intervals, and the number of bootstrap samples used to generate
confidence intervals. Additionally, it also includes information about
sample size, bending constant, no. of bootstrap samples, etc.
}
\description{
Custom function to get confidence intervals for percentage bend
correlation coefficient.
}
\examples{

# for reproducibility
set.seed(123)
\donttest{
statsExpressions:::robcor_ci(
  data = mtcars,
  x = "hp",
  y = "mpg",
  beta = .01,
  nboot = 25,
  conf.level = .99,
  conf.type = c("basic")
)
}
}
\keyword{internal}
