% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.utilities.R
\docType{data}
\name{snctrl_names}
\alias{snctrl_names}
\alias{snctrl-API}
\alias{update_snctrl}
\alias{collate_controls}
\alias{UPDATE_MY_SCTRL_EXPR}
\alias{COLLATE_ALL_MY_CONTROLS_EXPR}
\title{Helper functions used by packages to facilitate \code{\link{snctrl}} updating.}
\format{
\code{UPDATE_MY_SCTRL_EXPR} is a quoted expression meant to be passed directly to \code{\link[=eval]{eval()}}.

\code{COLLATE_ALL_MY_CONTROLS_EXPR} is a quoted expression meant to be passed directly to \code{\link[=eval]{eval()}}.
}
\usage{
snctrl_names()

update_snctrl(myname, arglists = NULL, callback = NULL)

collate_controls(x = NULL, ...)

UPDATE_MY_SCTRL_EXPR

COLLATE_ALL_MY_CONTROLS_EXPR
}
\arguments{
\item{myname}{Name of the package defining the arguments.}

\item{arglists}{A named list of argument name-default pairs. If the
list is not named, it is first passed through
\code{\link[=collate_controls]{collate_controls()}}.}

\item{callback}{A function with no arguments that updates the
packages own copy of \code{\link[=snctrl]{snctrl()}}.}

\item{x}{Either a function, a list of functions, or an
environment. If \code{x} is an environment, all functions starting
with dQuote(\code{control.}) are obtained.}

\item{...}{Additional functions or lists of functions.}
}
\value{
\code{update_snctrl()} has no return value and is used for its side-effects.

\code{collate_controls()} returns the combined list of name-default pairs of each function.
}
\description{
Helper functions used by packages to facilitate \code{\link{snctrl}} updating.
}
\section{Functions}{
\itemize{
\item \code{snctrl_names()}: Typeset the currently defined list of
argument names by package and control function.

\item \code{update_snctrl()}: Typically called from \code{\link[=.onLoad]{.onLoad()}}, Update the
argument list of \code{\link[=snctrl]{snctrl()}} to include additional argument names
associated with the package, and set a callback for the package
to update its own copy.

\item \code{collate_controls()}: Obtain and concatenate the argument lists of
specified functions or all functions starting with dQuote(\code{control.}) in
the environment.

\item \code{UPDATE_MY_SCTRL_EXPR}: A stored expression that, if evaluated, will
create a callback function \code{update_my_snctrl()} that will update
the client package's copy of \code{\link[=snctrl]{snctrl()}}.

\item \code{COLLATE_ALL_MY_CONTROLS_EXPR}: A stored expression that, if evaluated on
loading, will add arguments of the package's \verb{control.*()}
functions to \code{\link[=snctrl]{snctrl()}} and set the callback.

}}
\examples{
\dontrun{
# In the client package (outside any function):
eval(UPDATE_MY_SCTRL_EXPR)
}
\dontrun{
# In the client package:
.onLoad <- function(libame, pkgname){
  # ... other code ...
  eval(statnet.common::COLLATE_ALL_MY_CONTROLS_EXPR)
  # ... other code ...
}
}
}
\keyword{datasets}
