% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTD.R
\name{plot.TD}
\alias{plot.TD}
\title{Plot function for class TD}
\usage{
\method{plot}{TD}(
  x,
  ...,
  plotType = c("layout", "map", "box", "cor"),
  trials = names(x),
  traits = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class TD.}

\item{...}{Extra plot options. Described per plotType in their respective
section.}

\item{plotType}{A single character string indicating which plot should be
made. See the sections below for a detailed explanation of the plots.}

\item{trials}{A character vector indicating the trials to be plotted when
plotting field layouts. Only used if \code{plotType} = "layout" or "box".}

\item{traits}{A character vector indicating the traits to be plotted in
a boxplot. Only used if \code{plotType} = "box" or "cor".}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a list of ggplot objects is invisibly returned.}
}
\description{
Plotting function for objects of class TD. Plots either the layout of the
different trials within the TD object or locates the trials on a map. Also a
boxplot can be made for selected traits and trials and a plot of correlations
between trials. A detailed description and optional extra parameters of the
different plots is given in the sections below.
}
\section{Layout Plot}{

Plots the layout of the selected trials (all available trials by default).
This plot can only be made for trials that contain both row (\code{rowCoord})
and column (\code{colCoord}) information. If either one of those is missing
the trial is skipped with a warning. If blocks (\code{subBlock}) are
available for a trial these are indicated in different colors per block,
otherwise all plots are colored in grey. If replicates (\code{repId}) are
available a black line is plotted between diffent replicates. Missing plots
are indicated in white. This can either be single plots in a trial or
complete missing columns or rows.\cr
Extra parameter options:
\describe{
\item{showGeno}{Should individual genotypes be indicated in the plot?
Defaults to \code{FALSE}}
\item{highlight}{A character vector of genotypes to be highlighted in the
plot.}
\item{colorSubBlock}{Should subBlocks be colored with a different color per
subBlock? Defaults to \code{FALSE}. \code{colorSubBlock} is ignored when
highlight is used to highlight genotypes.}
}
}

\section{Map Plot}{

A map is plotted with the locations of the trials in the TD object.
Mapping the trials is done based on lattitude and longitude that can be
added when creating an object of class TD. Trials without latitude and/or
longitude available are skipped with a warning message. The countries in
which the trials are located will be plotted on a single map and the
location of the trials will be indicated on this map. The actual plot is
made using ggplot, but for getting the data for the borders of the countries
the maps package is needed. Extra parameter options:
\describe{
\item{minLatRange}{A positive numerical value indicating the minimum range
(in degrees) for the latitude on the plotted map. Defaults to 10.}
\item{minLongRange}{A positive numerical value indicating the minimum range
(in degrees) for the longitud on the plotted map. Defaults to 5.}
}
}

\section{Box Plot}{

Creates a boxplot per selected trait grouped by trial. Extra parameter
options:
\describe{
\item{groupBy}{A character string indicating a column in \code{TD} by which
the boxes in the plot should be grouped. By default the boxes are grouped
per trial.}
\item{colorBy}{A character string indicating a column in \code{TD} by which
the boxes are colored. Coloring will be done within the groups indicated by
the \code{groupBy} parameter.}
\item{orderBy}{A character string indicating the way the boxes should be
ordered. Either "alphabetic" for alphabetical ordering of the groups,
"ascending" for ordering by ascending mean, or "descending" for ordering by
descending mean. Default boxes are ordered alphabetically.}
}
}

\section{Correlation Plot}{

Draws a heatmap of correlations between trials per selected trait. If
genotypes are replicated within trials genotypic means are taken before
computing correlations. The order of the trials in the heatmap is determined
by clustering them.
}

\examples{
data("wheatChl")

## Create a TD object.
wheatTD <- createTD(data = wheatChl, genotype = "trt", repId = "rep",
                    subBlock = "bl", rowCoord = "row", colCoord = "col")

## Add meta data to be able to plot locations on a map.
wheatMeta <- getMeta(wheatTD)
wheatMeta$trLocation <- c("Cauquenes", rep("Santa Rosa", times = 4))
wheatMeta$trLat <- c(-35.58, rep(-36.32, times = 4))
wheatMeta$trLong <- c(-72.17, rep(-71.55, times = 4))
wheatTD <- setMeta(wheatTD, wheatMeta)

### Layout plot.

## Plot the layout of one of the trials.
plot(wheatTD, trials = "C_SWS_12")

## Highlight some of the genotypes in the layout.
plot(wheatTD, trials = "C_SWS_12", highlight = c("G001", "G002"))

### Map plot.

## Plot the location of the trials on the map.
plot(wheatTD, plotType = "map")

### Box plot.

## Create a box plot for GY.
plot(wheatTD, plotType = "box", traits = "GY")

## Add coloring by repId to the boxes.
plot(wheatTD, plotType = "box", traits = "GY", colorBy = "repId")

## Sort the boxes in descending order.
plot(wheatTD, plotType = "box", traits = "GY", orderBy = "descending")

### Correlation plot.

## Plot the correlations between trials for GY.
plot(wheatTD, plotType = "cor", traits = "GY")

}
\seealso{
Other functions for TD objects: 
\code{\link{TD}},
\code{\link{getMeta}()},
\code{\link{summary.TD}()}
}
\concept{functions for TD objects}
