% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSTA.R
\name{STAtoCross}
\alias{STAtoCross}
\title{Convert STA to Cross}
\usage{
STAtoCross(
  STA,
  trial = NULL,
  traits = NULL,
  what = c("BLUEs", "BLUPs"),
  genoFile,
  genotypes = c("A", "H", "B", "D", "C"),
  ...
)
}
\arguments{
\item{STA}{An object of class \code{STA}.}

\item{trial}{A character string indicating the trial to be exported. If
\code{NULL} and \code{STA} contains only one trial, that trial is exported.}

\item{traits}{A character string containing the traits to be exported. If
\code{NULL}, all traits for the selected trial are exported.}

\item{what}{A character string containing the statistics to be exported as
phenotype in the cross object. This can be either \code{BLUEs} or
\code{BLUPs}.}

\item{genoFile}{A character string indicating a filename containing
phenotypic data. The data should be in the format required by the
qtl package. The first column should contain the individuals, starting
from row 4. The following columns contain markers with in the second and
third row the chromosome and position on the chromosome and in the
following rows the genotypes.}

\item{genotypes}{A character vector specifying the genotype codes
corresponding to AA, AB, BB, not BB and not AA.}

\item{...}{Further arguments to be passed to the read.cross function.
See \code{\link[qtl]{read.cross}}.}
}
\description{
Convert an STA object to a cross object from package qtl. Genotypic
information should be available in a .csv file.\cr
The only way to create an object of class cross is by importing both the
phenotypic and the genotypic data from external files. Therefore the
phenotypic data, either the BLUEs or the BLUPs from the fitted model are
first written to a temporary file. The genotypic data has to be available in
a .csv file in the correct format as well, see \code{genoFile} for a
description of this format. These phenotypic and genotypic files are then
imported into a cross object using the read.cross function in the qtl
package.
}
\examples{
## Run model using SpATS.
myModel <- fitTD(TD = TDHeat05, design = "res.rowcol", traits = "yield",
                 what = "fixed")

## Create cross object with BLUEs from myModel using genotypic information
## from markers.csv in the package.
cross <- STAtoCross(myModel, genoFile = system.file("extdata", "markers.csv",
                                                    package = "statgenSTA"))

}
\seealso{
\code{\link[qtl]{read.cross}}

Other STA: 
\code{\link{STAtoTD}()},
\code{\link{plot.STA}()},
\code{\link{report.STA}()},
\code{\link{summary.STA}()}
}
\concept{STA}
