% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTD.R
\name{plot.TD}
\alias{plot.TD}
\title{Plot function for class TD}
\usage{
\method{plot}{TD}(
  x,
  ...,
  plotType = c("layout", "map", "box", "cor", "scatter"),
  trials = names(x),
  traits = NULL,
  title = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class TD.}

\item{...}{Extra plot options. Described per plotType in their respective
section.}

\item{plotType}{A single character string indicating which plot should be
made. See the sections below for a detailed explanation of the plots.}

\item{trials}{A character vector indicating which trials to include in the
plot.}

\item{traits}{A character vector indicating for which traits a plot should
be made. Ignored if \code{plotType} = "map".}

\item{title}{A character string used a title for the plot. Note that when
a title is specified and multiple plots are created, all plots will get the
same title.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a list of ggplot objects is invisibly returned.}
}
\description{
Plotting function for objects of class TD. Plots either the layout of the
different trials within the TD object or locates the trials on a map. Also a
boxplot can be made for selected traits and trials, a plot of correlations
between trials and a scatter plot matrix. A detailed description and optional
extra parameters of the different plots is given in the sections below.
}
\section{Layout Plot}{

Plots the layout of the selected trials.
This plot can only be made for trials that contain both row (\code{rowCoord})
and column (\code{colCoord}) information. If either one of those is missing
the trial is skipped with a warning. If blocks (\code{subBlock}) are
available for a trial these can be colored in different colors per block by
setting \code{colorSubBlock = TRUE}. If replicates (\code{repId}) are
available a black line is plotted between different replicates. Missing plots
are indicated in white. These can either be single plots in a trial or
complete missing columns or rows.\cr
Extra parameter options:
\describe{
\item{showGeno}{Should individual genotypes be indicated as text in the plot?
Defaults to \code{FALSE}}
\item{sizeGeno}{The text size for indicating individual genotypes. Defaults
to 2. Ignored if \code{showGeno = FALSE}.}
\item{highlight}{A character vector of genotypes to be highlighted in the
plot.}
\item{colHighlight}{A character vector specifying colors to use for the
highlighted genotypes. If not specified, default ggplot colors are used.}
\item{colorSubBlock}{Should blocks be colored with a different color per
subBlock? Defaults to \code{FALSE}. \code{colorSubBlock} is ignored when
highlight is used to highlight genotypes.}
\item{colSubBlock}{A character vector specifying colors to use for the
subBlocks. If not specified, default ggplot colors are used.}
}
}

\section{Map Plot}{

A map is plotted with the locations of the trials in the TD object.
Mapping the trials is done based on latitude and longitude that can be
added when creating an object of class TD. Trials for which either latitude
or longitude is not available are skipped with a warning message.
The countries in which the trials are located will be plotted on a single
map and the location of the trials will be indicated on this map. The
actual plot is made using ggplot, but for getting the data for the borders
of the countries the maps package is needed.\cr
Extra parameter options:
\describe{
\item{colorTrialBy}{A character string indicating a column in \code{TD} by
which the trials on the map are colored.}
\item{colTrial}{A character vector with plot colors for the trials. A
single color when \code{colorTrialBy = NULL}, a vector of colors otherwise.}
\item{printTrialNames}{Should trial names be printed. Defaults to
\code{TRUE}. Setting this to \code{FALSE} can be useful if there are many
trials.}
\item{minLatRange}{A positive numerical value indicating the minimum range
(in degrees) for the latitude on the plotted map. Defaults to 10.}
\item{minLongRange}{A positive numerical value indicating the minimum range
(in degrees) for the longitude on the plotted map. Defaults to 5.}
}
}

\section{Box Plot}{

Creates a boxplot per selected trait grouped by trial. Extra parameter
options:
\describe{
\item{groupBy}{A character string indicating a column in \code{TD} by which
the boxes in the plot should be grouped. By default the boxes are grouped
per trial.}
\item{colorTrialBy}{A character string indicating a column in \code{TD} by
which the boxes are colored. Coloring will be done within the groups
indicated by the \code{groupBy} parameter.}
\item{colTrial}{A character vector with plot colors for the trials. A
single color when \code{colorTrialBy = NULL}, a vector of colors otherwise.}
\item{orderBy}{A character string indicating the way the boxes should be
ordered. Either "alphabetic" for alphabetical ordering of the groups,
"ascending" for ordering by ascending mean, or "descending" for ordering by
descending mean. Default boxes are ordered alphabetically.}
}
}

\section{Correlation Plot}{

Draws a heat map of correlations between trials per selected trait. If
genotypes are replicated within trials genotypic means are taken before
computing correlations. The order of the trials in the heat map is determined
by clustering them. Closely related trials will be plotted close to each
other.
}

\section{Scatter Plot}{

Draws a scatter plot matrix per selected trait. If genotypes are replicated
within trials genotypic means are taken before plotting. The lower left of
the matrix contains scatter plots between trials. The diagonal contains
histograms of the data per trial.\cr
Extra parameter options:
\describe{
\item{colorGenoBy}{A character string indicating a column in \code{TD} by
which the genotypes in the scatter plots are colored.}
\item{colGeno}{A character vector with plot colors for the genotypes. A
single color when \code{colorGenoBy = NULL}, a vector of colors otherwise.}
\item{colorTrialBy}{A character string indicating a column in \code{TD} by
which the trials in the histograms are colored.}
\item{colTrial}{A character vector with plot colors for the trials. A
single color when \code{colorTrialBy = NULL}, a vector of colors otherwise.}
\item{trialOrder}{A character vector indicating the order of the trials in
the plot matrix (left to right and top to bottom). This vector should be a
permutation of all trials plotted.}
\item{addCorr}{A character string indicating the position of the correlation
between trials displayed in each plot, either "tl" for top left, "tr", for
top right, "bl" for bottom left or "br" for bottom right. If \code{NULL},
the default, then no correlation is added to the plot.}
}
}

\examples{
data("dropsRaw")

## Create a TD object.
dropsTD <- createTD(data = dropsRaw[dropsRaw$year == 2012, ],
                    genotype = "Variety_ID",
                    trial = "Experiment",
                    loc = "Site",
                    repId = "Replicate",
                    subBlock = "block",
                    rowCoord = "Row",
                    colCoord = "Column",
                    trLat = "Lat",
                    trLong = "Long")

### Layout plot.

\donttest{
## Plot the layout of one of the trials.
plot(dropsTD,
    trials = "Kar12W")

## Highlight some of the genotypes in the layout.
plot(dropsTD,
     trials = "Kar12W",
     highlight = c("A3", "11430"))

### Map plot.

## Plot the location of the trials on the map.
plot(dropsTD,
     plotType = "map")

### Box plot.

## Create a box plot for grain.yield.
plot(dropsTD,
     plotType = "box",
     traits = "grain.yield")

## Add coloring by scenarioFull to the boxes.
plot(dropsTD,
     plotType = "box",
     traits = "grain.yield",
     colorTrialBy = "scenarioFull")

## Sort the boxes in descending order.
plot(dropsTD,
     plotType = "box",
     traits = "grain.yield",
     orderBy = "descending")

### Correlation plot.

## Plot the correlations between trials for grain.yield.
plot(dropsTD,
     plotType = "cor",
     traits = "grain.yield")

### Scatter plot

## Plot scatter plot for grain.yield.
plot(dropsTD,
    plotType = "scatter",
    traits = "grain.yield")

## Create a scatter plot matrix for grain yield.
## Color trials by scenario and genotypes by family.
plot(dropsTD,
     plotType = "scatter",
     traits = "grain.yield",
     colorTrialBy = "scenarioFull",
     colorGenoBy = "geneticGroup")
}

}
\seealso{
Other functions for TD objects: 
\code{\link{TD}},
\code{\link{getMeta}()},
\code{\link{summary.TD}()}
}
\concept{functions for TD objects}
