% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDprob.R
\name{plot.IBDprob}
\alias{plot.IBDprob}
\title{Plot function for objects of class IBDprob}
\usage{
\method{plot}{IBDprob}(x, ..., genotype, title = genotype, output = TRUE)
}
\arguments{
\item{x}{An object of class \code{IBDprob}.}

\item{...}{Further arguments. Unused.}

\item{genotype}{A character string indicating the genotype for which the
plot should be made.}

\item{title}{A character string, the title of the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE}, only a ggplot object is invisibly returned.}
}
\value{
A ggplot object is invisibly returned.
}
\description{
Creates a plot for an object of class \code{IBDprob}.
}
\examples{
## Compute IBD probabilities for Steptoe Morex.
## Add extra evaluation positions in between exiting marker positions
## to assure evaluation positions are at most 2 cM apart.
SxMIBD_Ext <- calcIBD(popType = "DH",
                      markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                              package = "statgenIBD"),
                      mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                           package = "statgenIBD"),
                      evalDist = 2)

## Plot results for genotype dh005.
plot(SxMIBD_Ext,
     genotype = "dh005")

}
