/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.BGZIPOutputStream;
import blbutil.Utilities;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class FileUtil {
    private FileUtil() {
    }

    public static FileInputStream fileInputStream(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        return fileInputStream;
    }

    public static FileOutputStream fileOutputStream(File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        return fileOutputStream;
    }

    public static FileOutputStream fileOutputStream(File file, boolean bl) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        return fileOutputStream;
    }

    public static PrintWriter stdOutPrintWriter() {
        return new PrintWriter(new BufferedOutputStream(System.out));
    }

    public static PrintWriter gzipPrintWriter(File file) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
            printWriter = new PrintWriter(gZIPOutputStream);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static PrintWriter bgzipPrintWriter(File file) {
        boolean bl = true;
        FileOutputStream fileOutputStream = FileUtil.fileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        return new PrintWriter(new BGZIPOutputStream(bufferedOutputStream, bl));
    }

    public static PrintWriter bgzipPrintWriter(File file, boolean bl) {
        boolean bl2 = true;
        FileOutputStream fileOutputStream = FileUtil.fileOutputStream(file, bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        return new PrintWriter(new BGZIPOutputStream(bufferedOutputStream, bl2));
    }

    public static PrintWriter printWriter(File file) {
        return FileUtil.printWriter(file, false);
    }

    public static PrintWriter printWriter(File file, boolean bl) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, bl)));
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static PrintWriter nonBufferedPrintWriter(File file, boolean bl) {
        boolean bl2 = true;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file, bl), bl2);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static File tempFile(String string) {
        File file = null;
        try {
            file = File.createTempFile(string, null);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            Utilities.exit("Exception thrown by createTempFile: ", iOException);
        }
        return file;
    }
}

