% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlead-tlag.R
\name{tlead-tlag}
\alias{tlag}
\alias{tlead}
\alias{tlead-tlag}
\title{lead and lag with respect to a time variable}
\usage{
tlead(x, n = 1L, time, default = NA)

tlag(x, n = 1L, time, default = NA)
}
\arguments{
\item{x}{a vector of values}

\item{n}{a positive integer of length 1, giving the number of positions to lead or lag by. When the package lubridate is loaded, it can be a period when using with time (see the lubridate function minutes, hours, days, weeks, months and years)}

\item{time}{time variable}

\item{default}{value used for non-existant rows. Defaults to \code{NA}.}
}
\description{
lead and lag with respect to a time variable
}
\examples{
date <- c(1989, 1991, 1992)
value <- c(4.1, 4.5, 3.3)
tlag(value, 1, time = date) #  returns value in year - 1
library(lubridate)
date <- as.monthly(mdy(c("01/04/1992", "03/15/1992", "04/03/1992")))
tlag(value, time = date) 
library(dplyr)
df <- data_frame(
   id    = c(1, 2, 2),
   date  = date,
   value = value
)
df \%>\% group_by(id) \%>\% mutate(valuel = tlag(value, n = 1, time = date))
}

