% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/setmutate.R
\name{setmutate}
\alias{setmutate}
\alias{setmutate_}
\title{Version of mutate that (i) transforms data.table in place (ii) allows by, i condition}
\usage{
setmutate(x, ..., i = NULL, by = NULL)

setmutate_(x, vars, i = NULL, by = NULL)
}
\arguments{
\item{x}{a data.table}

\item{...}{Variables to include. Defaults to all non-grouping variables.}

\item{i}{a condition that restricts the set of row on which to apply the function}

\item{by}{Groups within which the function should be applied}

\item{vars}{Used to work around non-standard evaluation.}
}
\description{
Version of mutate that (i) transforms data.table in place (ii) allows by, i condition
}
\examples{
library(data.table)
library(dplyr)
N <- 100
DT <- data.table(
  id = sample(5, N, TRUE),
  v1 = sample(5, N, TRUE),
  v2 = sample(1e6, N, TRUE)
)
setmutate(DT, mean(v2), by = v1)
setmutate_(DT, setNames("mean(v2)", "v3"), by = "v1")
setmutate_(DT, setNames("mean(v2)", "v3"), i = "id==1", by = "v1")
}

