% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{sp.anogva}
\alias{sp.anogva}
\title{Semi-Parametric Analysis Of Graph Variability (ANOGVA)}
\usage{
sp.anogva(
  G,
  model,
  maxBoot = 500,
  spectra = NULL,
  eps = 0.01,
  classic = FALSE,
  bandwidth = "Silverman"
)
}
\arguments{
\item{G}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{model}{A string that indicates one of the following models: "ER"
(Erdos-Renyi random graph model), "GRG" (geometric random graph model), "WS"
(Watts-Strogatz random graph model), and "BA" (Barabasi-Albert random graph
model).}

\item{maxBoot}{integer indicating the number of bootstrap resamples (default
is 500).}

\item{spectra}{optional parameter containing the precomputed spectrum of the
model. It is a three-dimensional array in which the first dimension
corresponds to all parameters that will be explored in the parameter
estimation, the second dimension has the same size of the given graph, and
the third one corresponds to graphs randomly generated by the model. Thus,
the position (i,j,k) contains the j-th eigenvalue of the k-th graph generated
with the i-th parameter. The attribute 'rownames' of the array corresponds to
the parameters converted to string. If spectra is NULL (default), then
model' is used to generate random graphs and their spectra are computed
automatically.}

\item{eps}{(default is 0.01) precision of the grid when 'classic' = TRUE.}

\item{classic}{logical. If FALSE (default) parameter is estimated using
ternary search, if TRUE parameter is estimated using grid search.}

\item{bandwidth}{string showing which criterion is used to choose the
bandwidth during the spectral density estimation. Choose between the
following criteria: "Silverman" (default), "Sturges", "bcv", "ucv" and "SJ".
"bcv" is an abbreviation of biased cross-validation, while "ucv" means
unbiased cross-validation. "SJ"  implements the methods of Sheather & Jones
(1991) to select the bandwidth using pilot estimation of derivatives.}
}
\value{
A list containing:
\item{parameters}{a vector containing the estimated parameters for each
graph.}
\item{F.value}{the F statistic of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
\code{sp.anogva} statistically tests whether two or more graphs are
generated by the same model and set of parameters.
}
\examples{
\dontrun{
set.seed(42)
model <- "ER"
G <- list()

# Under H0
G[[1]] <- igraph::sample_gnp(50, 0.5)
G[[2]] <- igraph::sample_gnp(50, 0.5)
G[[3]] <- igraph::sample_gnp(50, 0.5)
result1 <- sp.anogva(G, model, maxBoot = 300)
result1

# Under H1
G[[1]] <- igraph::sample_gnp(50, 0.5)
G[[2]] <- igraph::sample_gnp(50, 0.55)
G[[3]] <- igraph::sample_gnp(50, 0.5)
result2 <- sp.anogva(G, model, maxBoot = 300)
result2
}

}
\references{
Andre Fujita, Eduardo Silva Lira, Suzana de Siqueira Santos, Silvia Yumi
Bando, Gabriela Eleuterio Soares, Daniel Yasumasa Takahashi. A
semi-parametric statistical test to compare complex networks, Journal of
Complex Networks, cnz028, https://doi.org/10.1093/comnet/cnz028

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{semi_parametric_analysis_of_graph_variability}
