% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_bern.R
\name{ci_bern}
\alias{ci_bern}
\title{Confidence Interval for Proportion}
\usage{
ci_bern(x, n = NULL, conf_level = 0.95, type = "two.sided", na.rm = F)
}
\arguments{
\item{x}{a vector of counts of successes.}

\item{n}{a vector of counts of trials.}

\item{conf_level}{confidence level of the returned confidence interval. Must be a single number between 0 and 1.}

\item{type}{a character string specifying the type of confidence interval. Must be one of "two.sided" (default), "right" or "left".}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}
}
\value{
A 1 x 3 tibble with 'lower_ci', 'upper_ci' and 'conf_level' columns. Values correspond to lower, upper bounds of the confidence interval and confidence level, respectively.
}
\description{
Confidence Interval for Proportion
}
\details{
\code{type} specifies the type of confidence interval. If \code{type} is "two.sided",  the returned confidence interval is \code{(lower_ci, upper_ci)}. If \code{type} is "left", the returned confidence interval is \code{(lower_ci, 1)}. And, finally, is \code{type} is "right", the returned confidence interval is \code{(0, upper_ci))}.
}
\examples{
heads <- rbinom(1, size = 100, prob = .5)
ci_bern(heads)

}
