% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/on_session_enter.R, R/on_session_exit.R
\name{on_session_enter}
\alias{on_session_enter}
\alias{on_session_exit}
\title{Register functions to be evaluated at the beginning or end of the R session}
\usage{
on_session_enter(fcn = NULL, append = TRUE, replace = FALSE)

on_session_exit(fcn = NULL, append = TRUE, replace = FALSE)
}
\arguments{
\item{fcn}{A function or an R expression. The function must accept zero
or more arguments (currently not used). If an expression, it will
automatically we wrapped up in an anonymous function.}

\item{append}{If TRUE (default), the function will be evaluated after
previously registered ones, otherwise prepended.}

\item{replace}{if TRUE, the function replaces any previously registered
ones, otherwise it will be added (default).}
}
\value{
(invisible) the list of registered functions.
}
\description{
Register functions to be evaluated at the beginning or end of the R session
}
\details{
These functions register one or more functions to be called when the
current R session begins or ends.  The functions are evaluated in a local
environment and without exception handlers, which means that if one
produces an error, then none of the succeeding functions will be called.

To list currently registered functions, use \code{fcns <- on_session_enter()}
or \code{fcns <- on_session_exit()}.
To remove all registered functions, use \code{on_session_enter(replace = TRUE)}
or \code{on_session_exit(replace = TRUE)}.

The \code{on_session_enter()} function works by recording all \code{fcn}:s in an
internal list which will be evaluated via a custom
\code{\link[base:.First]{.First()}} function created in the global
environment. Any other \code{.First()} function on the search path, including
a pre-existing \code{.First()} function in the global environment, is called
at the end after registered functions have been called.

The \code{on_session_exit()} function works by recording all \code{fcn}:s in an
internal list which will be evaluated via a custom function that is called
when the global environment is garbage collected, which happens at the very
end of the R shutdown process.
Contrary to a \code{\link[base:.Last]{.Last()}} function, which is not be
called if \code{quit(runLast = FALSE)} is used, functions registered via
\code{on_session_exit()} are always processed.
Registered \code{on_session_exit()} functions are called \emph{after} \code{quit()} saves
any workspace image to file (\code{./.RData}), and \emph{after} any \code{.Last()} has
been called.
}
\examples{
\dontrun{
## Summarize interactive session upon termination
if (interactive()) {
  startup::on_session_exit(local({
    t0 <- Sys.time()
    function(...) {
      dt <- difftime(Sys.time(), t0, units = "auto")
      msg <- c(
        "Session summary:",
        sprintf(" * R version: \%s", getRversion()),
        sprintf(" * Process ID: \%d", Sys.getpid()),
        sprintf(" * Wall time: \%.2f \%s", dt, attr(dt, "units"))
      )
      msg <- paste(msg, collapse = "\n")
      message(msg)
    }
  }))
}
}

}
