% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NcVarReader.R
\name{NcVarReader}
\alias{NcVarReader}
\title{NetCDF variable reader for 'startR'}
\usage{
NcVarReader(file_path = NULL, file_object = NULL, file_selectors = NULL,
  var_name = NULL, synonims)
}
\arguments{
\item{file_path}{A character string indicating the path to the data file to 
read the variable from. See details in the documentation of the parameter 
'file_var_reader' of the function Start(). The default value is NULL.}

\item{file_object}{An open connection to a NetCDF file, optionally with 
additional header information. See details in the documentation of the 
parameter 'file_var_reader' of the function Start(). The default value is 
NULL.}

\item{file_selectors}{A named list containing the information of the path of 
the file to read data from. It is automatically provided by Start(). See 
details in the documentation of the parameter 'file_var_reader' of the 
function Start(). The default value is NULL.}

\item{var_name}{A character string with the name of the variable to be read.
The default value is NULL.}

\item{synonims}{A named list indicating the synonims for the dimension names 
to look for in the requested file, exactly as provided in the parameter 
'synonims' in a Start() call. See details in the documentation of the 
parameter 'file_var_reader' of the function Start().}
}
\value{
A multidimensional data array with the named dimensions, potentially 
 with the attribute 'variables' with additional auxiliary data. See details 
 in the documentation of the parameter 'file_var_reader' of the function 
 Start().
}
\description{
This is an auxiliary variable reader function for NetCDF files, intended for 
use as parameter 'file_var_reader' in a Start() call. It complies with the 
input/output interface required by Start() defined in the documentation for 
the parameter 'file_var_reader' of that function.\cr\cr
This function uses the function NcDataReader() in the package 'startR', 
which in turn uses NcToArray() in the package 'easyNCDF', which in turn uses 
nc_var_get() in the package 'ncdf4'.
}
\examples{
 data_path <- system.file('extdata', package = 'startR')
 file_to_open <- file.path(data_path, 'obs/monthly_mean/tos/tos_200011.nc')
 file_selectors <- c(dat = 'dat1', var = 'tos', sdate = '200011')
 synonims <- list(dat = 'dat', var = 'var', sdate = 'sdate', time = 'time',
                  latitude = 'latitude', longitude = 'longitude')
 var <- NcVarReader(file_to_open, NULL, file_selectors,
                     'tos', synonims)
}
\seealso{
\code{\link{NcOpener}} \code{\link{NcDataReader}} 
 \code{\link{NcCloser}} \code{\link{NcDimReader}}
}

