% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanModel.R
\name{compile}
\alias{compile}
\title{Compilation of Stan code}
\usage{
compile(model, stanfilepath = NULL)
}
\arguments{
\item{model}{a \code{PMXStanModel} object.}

\item{stanfilepath}{a string for user to specify the path of the Stan code. The default is NULL, and the
location of the Stan file to be compiled will be decided by \code{model} above.}
}
\value{
No explicit return; a successful compilation will generate an executable code as part of the current
        \code{PMXStanModel} object.
}
\description{
Compiles a piece of model-specific Stan code, as part of a \code{PMXStanModel} object, into an executable.
}
\details{
This is a generic version of the method \code{compile.stanmodel()} for the \code{\link{PMXStanModel}} class. 
The compilation step can also be performed simultaneous during the initialization process of a 
\code{PMXStanModel} object, by setting the argument \code{compile = TRUE}.
}
\examples{
\donttest{
m <- PMXStanModel(path = tempfile("pk_m1"))
compile(m)

m$compile.stanmodel()

m <- PMXStanModel(path = tempfile("pk_m1"), compile = TRUE)
}
}
\seealso{
\code{\link{PMXStanModel}} for the method \code{compile.stanmodel()} and the argument \code{compile}.
}

