% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{inclusions_stages}
\alias{inclusions_stages}
\title{Inclusions of stages}
\usage{
inclusions_stages(object1, object2)
}
\arguments{
\item{object1}{an object of class \code{sevt}.}

\item{object2}{an object of class \code{sevt}.}
}
\value{
a list with inclusion relations between stage
structures for each variable in the models.
}
\description{
Display the relationship between two staged tree models over the
same variables.
}
\details{
Computes the
relations between
the stages structures of the two models.

The relations between stages of the same variable
are stored in a data frame with three columns
where each row represent
a relation between a stage of the first model (\code{s1}) and
a stage of the second model (\code{s2}).
The relation can be one of the following: inclusion (\code{s1 < s2}
or \code{s1 > s2}; equal (\code{s1 = s2}); not-equal (\code{s1 != s2}).
}
\examples{
mod1 <- stages_bhc(full(PhDArticles[, 1:5], lambda = 1))
mod2 <- stages_fbhc(full(PhDArticles[, 1:5], lambda = 1))
inclusions_stages(mod1, mod2)
}
