% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{stndnaming}
\alias{stndnaming}
\title{Standard renaming of stages}
\usage{
stndnaming(
  object,
  uniq = FALSE,
  prefix = FALSE,
  ignore = object$name_unobserved
)
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{uniq}{logical, if stage numbers should be unique over all tree.}

\item{prefix}{logical, if stage names should be prefixed with variable name.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}
}
\value{
a staged event tree object with stages named with
consecutive integers.
}
\description{
Rename all stages in a staged event tree.
}
\examples{
model <- stages_fbhc(full(PhDArticles, join_unobserved = TRUE))
model$stages
model1 <- stndnaming(model)
model1$stages

### unique stage names in all tree
model2 <- stndnaming(model, uniq = TRUE)
model2$stages

### prefix stage names with variable name 
model3 <- stndnaming(model, prefix = TRUE)
model3$stages

### manuallty select stage names left untouched
model4 <- stndnaming(model, ignore = c("2", "6"), prefix = TRUE)
model4$stages
}
