% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\docType{data}
\name{example_data}
\alias{example_data}
\alias{reg_res_svm}
\alias{reg_res_sp}
\alias{reg_res_lr}
\alias{reg_folds}
\alias{class_res_nn}
\alias{class_res_rf}
\alias{class_folds}
\alias{log_res_nn}
\alias{log_res_rf}
\alias{tree_frogs_reg_test}
\alias{tree_frogs_class_test}
\title{Example Objects}
\format{
An object of class \code{tune_results} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.

An object of class \code{tune_results} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.

An object of class \code{resample_results} (inherits from \code{tune_results}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.

An object of class \code{vfold_cv} (inherits from \code{rset}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 2 columns.

An object of class \code{resample_results} (inherits from \code{tune_results}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.

An object of class \code{tune_results} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.

An object of class \code{vfold_cv} (inherits from \code{rset}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 2 columns.

An object of class \code{resample_results} (inherits from \code{tune_results}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.

An object of class \code{tune_results} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 5 rows and 5 columns.
}
\source{
Julie Jung et al. (2020) Multimodal mechanosensing enables treefrog
embryos to escape egg-predators. \doi{10.1242/jeb.236141}
}
\usage{
reg_res_svm

reg_res_sp

reg_res_lr

reg_folds

class_res_nn

class_res_rf

class_folds

log_res_nn

log_res_rf
}
\description{
stacks provides some resampling objects and datasets for use in examples
and vignettes derived from a study on 1212 red-eyed tree frog embryos!
}
\details{
Red-eyed tree frog (RETF) embryos can hatch earlier than their normal
7ish days if they detect potential predator threat. Researchers wanted
to determine how, and when, these tree frog embryos were able to detect
stimulus from their environment. To do so, they subjected the embryos
at varying developmental stages to "predator stimulus" by jiggling
the embryos with a blunt probe. Beforehand, though some of the embryos
were treated with gentamicin, a compound that knocks out their lateral
line (a sensory organ.) Researcher Julie Jung and her crew found that
these factors inform whether an embryo hatches prematurely or not!

Note that the data included with the stacks package is not necessarily
a representative or unbiased subset of the complete dataset, and is
only for demonstrative purposes.

\code{reg_folds} and \code{class_folds} are \code{rset} cross-fold validation objects
from \code{rsample}, splitting the training data into for the regression
and classification model objects, respectively. \code{tree_frogs_reg_test} and
\code{tree_frogs_class_test} are the analogous testing sets.

\code{reg_res_lr}, \code{reg_res_svm}, and \code{reg_res_sp} contain regression tuning results
for a linear regression, support vector machine, and spline model, respectively,
fitting \code{latency} (i.e. how long the embryos took to hatch in response
to the jiggle) in the \code{tree_frogs} data, using most all of the other
variables as predictors. Note that the data underlying these models is
filtered to include data only from embryos that hatched in response to
the stimulus.

\code{class_res_rf} and \code{class_res_nn} contain multiclass classification tuning
results for a random forest and neural network classification model,
respectively, fitting \code{reflex} (a measure of ear function) in the
data using most all of the other variables as predictors.

\code{log_res_rf} and \code{log_res_nn}, contain binary classification tuning results
for a random forest and neural network classification model, respectively,
fitting \code{hatched} (whether or not the embryos hatched in response
to the stimulus) using most all of the other variables as predictors.

The source code for generating these objects is given below.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# setup: packages, data, resample, basic recipe ------------------------
library(stacks)
library(tune)
library(rsample)
library(parsnip)
library(workflows)
library(recipes)
library(yardstick)
library(workflowsets)

set.seed(1)

ctrl_grid <- 
  tune::control_grid(
    save_pred = TRUE,
    save_workflow = TRUE
  )

ctrl_res <- 
  tune::control_resamples(
    save_pred = TRUE,
    save_workflow = TRUE
  )

# for regression, predict latency to hatch (excluding NAs)
tree_frogs_reg <- 
  tree_frogs |> 
  filter(!is.na(latency)) |>
  select(-clutch, -hatched)

set.seed(1)
tree_frogs_reg_split <- rsample::initial_split(tree_frogs_reg)

set.seed(1)
tree_frogs_reg_train <- rsample::training(tree_frogs_reg_split)

set.seed(1)
tree_frogs_reg_test  <- rsample::testing(tree_frogs_reg_split)

set.seed(1)
reg_folds <- rsample::vfold_cv(tree_frogs_reg_train, v = 5)

tree_frogs_reg_rec <- 
  recipes::recipe(latency ~ ., data = tree_frogs_reg_train) |>
  recipes::step_dummy(recipes::all_nominal()) |>
  recipes::step_zv(recipes::all_predictors())

metric <- yardstick::metric_set(yardstick::rmse)

# linear regression ---------------------------------------
lin_reg_spec <-
  parsnip::linear_reg() |>
  parsnip::set_engine("lm")

reg_wf_lr <- 
  workflows::workflow() |>
  workflows::add_model(lin_reg_spec) |>
  workflows::add_recipe(tree_frogs_reg_rec)

set.seed(1)
reg_res_lr <- 
  tune::fit_resamples(
    object = reg_wf_lr,
    resamples = reg_folds,
    metrics = metric,
    control = ctrl_res
  )

# SVM regression ----------------------------------
svm_spec <- 
  parsnip::svm_rbf(
    cost = tune::tune(), 
    rbf_sigma = tune::tune()
  ) |>
  parsnip::set_engine("kernlab") |>
  parsnip::set_mode("regression")

reg_wf_svm <- 
  workflows::workflow() |>
  workflows::add_model(svm_spec) |>
  workflows::add_recipe(tree_frogs_reg_rec)

set.seed(1)
reg_res_svm <- 
  tune::tune_grid(
    object = reg_wf_svm,
    resamples = reg_folds, 
    grid = 5,
    control = ctrl_grid
  )

# spline regression ---------------------------------------
spline_rec <- 
  tree_frogs_reg_rec |>
  recipes::step_ns(age, deg_free = tune::tune("age"))

reg_wf_sp <- 
  workflows::workflow() |>
  workflows::add_model(lin_reg_spec) |>
  workflows::add_recipe(spline_rec)

set.seed(1)
reg_res_sp <- 
  tune::tune_grid(
    object = reg_wf_sp,
    resamples = reg_folds,
    metrics = metric,
    control = ctrl_grid
  )

# classification - preliminaries -----------------------------------
tree_frogs_class <- 
  tree_frogs |>
  dplyr::select(-c(clutch, latency))

set.seed(1)
tree_frogs_class_split <- rsample::initial_split(tree_frogs_class)

set.seed(1)
tree_frogs_class_train <- rsample::training(tree_frogs_class_split)

set.seed(1)
tree_frogs_class_test  <- rsample::testing(tree_frogs_class_split)

set.seed(1)
class_folds <- rsample::vfold_cv(tree_frogs_class_train, v = 5)

tree_frogs_class_rec <- 
  recipes::recipe(reflex ~ ., data = tree_frogs_class_train) |>
  recipes::step_dummy(recipes::all_nominal(), -reflex) |>
  recipes::step_zv(recipes::all_predictors()) |>
  recipes::step_normalize(recipes::all_numeric())

# random forest classification --------------------------------------
rand_forest_spec <- 
  parsnip::rand_forest(
    mtry = tune::tune(),
    trees = 500,
    min_n = tune::tune()
  ) |>
  parsnip::set_mode("classification") |>
  parsnip::set_engine("ranger")

class_wf_rf <-
  workflows::workflow() |>
  workflows::add_recipe(tree_frogs_class_rec) |>
  workflows::add_model(rand_forest_spec)

set.seed(1)
class_res_rf <- 
  tune::tune_grid(
    object = class_wf_rf, 
    resamples = class_folds, 
    grid = 10,
    control = ctrl_grid
  )

# neural network classification -------------------------------------
nnet_spec <-
  mlp(hidden_units = 5, penalty = 0.01, epochs = 100) |>
  set_mode("classification") |>
  set_engine("nnet")

class_wf_nn <- 
  workflows::workflow() |>
  workflows::add_recipe(tree_frogs_class_rec) |>
  workflows::add_model(nnet_spec)

set.seed(1)
class_res_nn <-
  tune::fit_resamples(
    object = class_wf_nn, 
    resamples = class_folds, 
    control = ctrl_res
  )

# binary classification --------------------------------
tree_frogs_2_class_rec <- 
  recipes::recipe(hatched ~ ., data = tree_frogs_class_train) |>
  recipes::step_dummy(recipes::all_nominal(), -hatched) |>
  recipes::step_zv(recipes::all_predictors()) |>
  recipes::step_normalize(recipes::all_numeric())

set.seed(1)
rand_forest_spec_2 <- 
  parsnip::rand_forest(
    mtry = tune(),
    trees = 500,
    min_n = tune()
  ) |>
  parsnip::set_mode("classification") |>
  parsnip::set_engine("ranger")

log_wf_rf <-
  workflows::workflow() |>
  workflows::add_recipe(tree_frogs_2_class_rec) |>
  workflows::add_model(rand_forest_spec_2)

set.seed(1)
log_res_rf <- 
  tune::tune_grid(
    object = log_wf_rf, 
    resamples = class_folds, 
    grid = 10,
    control = ctrl_grid
  )

nnet_spec_2 <-
  parsnip::mlp(epochs = 100, hidden_units = 5, penalty = 0.1) |>
  parsnip::set_mode("classification") |>
  parsnip::set_engine("nnet", verbose = 0)

log_wf_nn <- 
  workflows::workflow() |>
  workflows::add_recipe(tree_frogs_2_class_rec) |>
  workflows::add_model(nnet_spec_2)

set.seed(1)
log_res_nn <-
  tune::fit_resamples(
    object = log_wf_nn, 
    resamples = class_folds, 
    control = ctrl_res
  )
}\if{html}{\out{</div>}}
}
\keyword{datasets}
