% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_parameters.R
\name{collect_parameters}
\alias{collect_parameters}
\alias{collect_parameters.default}
\alias{collect_parameters.data_stack}
\alias{collect_parameters.model_stack}
\title{Collect candidate parameters and stacking coefficients}
\usage{
collect_parameters(stack, candidates, ...)

\method{collect_parameters}{default}(stack, candidates, ...)

\method{collect_parameters}{data_stack}(stack, candidates, ...)

\method{collect_parameters}{model_stack}(stack, candidates, ...)
}
\arguments{
\item{stack}{A \code{data_stack} or \code{model_stack} object.}

\item{candidates}{The name of the candidates to collect parameters on.
This will either be the \code{name} argument supplied to \code{\link[=add_candidates]{add_candidates()}} or,
if not supplied, the name of the object supplied to the \code{candidates}
argument in \code{\link[=add_candidates]{add_candidates()}}.}

\item{...}{Additional arguments. Currently ignored.}
}
\value{
A \link[tibble:tbl_df-class]{tibble::tbl_df} with information on member names and hyperparameters.
}
\description{
A function to help situate candidates within a stack. Takes in a data
stack or model stack and candidate name and returns a tibble mapping the
candidate/member names to their hyperparameters (and, if a model stack,
to their stacking coefficients as well).
}
\section{Example Data}{


This package provides some resampling objects and datasets for use in examples
and vignettes derived from a study on 1212 red-eyed tree frog embryos!

Red-eyed tree frog (RETF) embryos can hatch earlier than their normal
7ish days if they detect potential predator threat. Researchers wanted
to determine how, and when, these tree frog embryos were able to detect
stimulus from their environment. To do so, they subjected the embryos
at varying developmental stages to "predator stimulus" by jiggling
the embryos with a blunt probe. Beforehand, though some of the embryos
were treated with gentamicin, a compound that knocks out their lateral
line (a sensory organ.) Researcher Julie Jung and her crew found that
these factors inform whether an embryo hatches prematurely or not!

Note that the data included with the stacks package is not necessarily
a representative or unbiased subset of the complete dataset, and is
only for demonstrative purposes.

\code{reg_folds} and \code{class_folds} are \code{rset} cross-fold validation objects
from \code{rsample}, splitting the training data into for the regression
and classification model objects, respectively. \code{tree_frogs_reg_test} and
\code{tree_frogs_class_test} are the analogous testing sets.

\code{reg_res_lr}, \code{reg_res_svm}, and \code{reg_res_sp} contain regression tuning results
for a linear regression, support vector machine, and spline model, respectively,
fitting \code{latency} (i.e. how long the embryos took to hatch in response
to the jiggle) in the \code{tree_frogs} data, using most all of the other
variables as predictors. Note that the data underlying these models is
filtered to include data only from embryos that hatched in response to
the stimulus.

\code{class_res_rf} and \code{class_res_nn} contain multiclass classification tuning
results for a random forest and neural network classification model,
respectively, fitting \code{reflex} (a measure of ear function) in the
data using most all of the other variables as predictors.

\code{log_res_rf} and \code{log_res_nn}, contain binary classification tuning results
for a random forest and neural network classification model, respectively,
fitting \code{hatched} (whether or not the embryos hatched in response
to the stimulus) using most all of the other variables as predictors.

See \code{?example_data} to learn more about these objects, as well as browse
the source code that generated them.
}

\examples{
\dontshow{if ((stacks:::should_run_examples(suggests = "kernlab"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# see the "Example Data" section above for
# clarification on the objects used in these examples!

# put together a data stack using
# tuning results for regression models
reg_st <-
  stacks() |>
  add_candidates(reg_res_lr) |>
  add_candidates(reg_res_svm) |>
  add_candidates(reg_res_sp, "spline")

reg_st

# check out the hyperparameters for some of the candidates
collect_parameters(reg_st, "reg_res_svm")

collect_parameters(reg_st, "spline")

# blend the data stack to view the hyperparameters
# along with the stacking coefficients!
collect_parameters(
  reg_st |> blend_predictions(),
  "spline"
)
\dontshow{\}) # examplesIf}
}
