% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asset-valuation.R
\name{valInfo.asset}
\alias{valInfo.asset}
\title{Providing Valuation Information for Asset with Direct Market
Price}
\usage{
\method{valInfo}{asset}(object, market.risk, standalone = NULL, ...)
}
\arguments{
\item{object}{S3 object of class asset.}

\item{market.risk}{S3 object of class marketRisk created using
the constructor \code{marketRisk}.}

\item{standalone}{S3 object of class standalone.}

\item{...}{additional arguments.}
}
\value{
a list with the following elements:
\itemize{
  \item \code{exposure}: numeric value of length one representing the exposure
    in the underlying asset.
  \item \code{constant}: numeric value of length one representing the constant
    centering the log-normal expression.
  \item \code{risk.factor}: a \code{data.frame} with columns:
  \itemize{
    \item \code{name}: character value representing the names of
      the base risk-factors.
    \item \code{id}: integer value representing the positions of
      the base risk-factors in the covariance matrix in \code{marketRisk}.
    \item \code{scale}: numeric value representing the scaling coefficients
      associated to the base risk-factors.
  }
}
}
\description{
\code{valInfo} is a generic S3 method for classes
  inheriting from item. It returns sufficient information for the
  creation of the valuation function of an item.
}
\seealso{
\code{\link{valInfo}}, \code{\link{asset}},
  \code{\link{marketRisk}}, \code{\link{standalone}}.
}
