% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure.R
\name{ssd_exposure}
\alias{ssd_exposure}
\title{Proportion Exposure}
\usage{
ssd_exposure(x, meanlog = 0, sdlog = 1, nboot = 1000)
}
\arguments{
\item{x}{The object.}

\item{meanlog}{The mean of the exposure concentrations on the log scale.}

\item{sdlog}{The standard deviation of the exposure concentrations on the log scale.}

\item{nboot}{The number of samples to use to calculate the exposure.}
}
\value{
The proportion exposed.
}
\description{
Calculates average proportion exposed based on log-normal distribution of concentrations.
}
\examples{
\dontrun{
fits <- ssd_fit_dists(ssddata::ccme_boron, dists = "lnorm")
set.seed(10)
ssd_exposure(fits)
ssd_exposure(fits, meanlog = 1)
ssd_exposure(fits, meanlog = 1, sdlog = 1)
}
}
