% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ssd_sort_data}
\alias{ssd_sort_data}
\title{Sort Species Sensitivity Data}
\usage{
ssd_sort_data(data, left = "Conc", right = left)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}
}
\value{
data sorted by the empirical cumulative density.
}
\description{
Sorts Species Sensitivity Data by empirical cumulative density (ECD).
}
\details{
Useful for sorting data before using \code{\link[=geom_ssdpoint]{geom_ssdpoint()}} and \code{\link[=geom_ssdsegment]{geom_ssdsegment()}}
to construct plots for censored data with \code{stat = identity} to
ensure order is the same for the various components.
}
\examples{
ssd_sort_data(ssddata::ccme_boron)
}
\seealso{
\code{\link[=ssd_ecd_data]{ssd_ecd_data()}} and \code{\link[=ssd_data]{ssd_data()}}
}
