% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{ssd_fit_dists}
\alias{ssd_fit_dists}
\title{Fit Distributions}
\usage{
ssd_fit_dists(
  data,
  left = "Conc",
  right = left,
  weight = NULL,
  dists = c("llogis", "gamma", "lnorm"),
  computable = FALSE,
  silent = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{weight}{A string of the column in data with the weightings (or NULL)}

\item{dists}{A character vector of the distribution names.}

\item{computable}{A flag specifying whether to only return fits with numerically computable standard errors.}

\item{silent}{A flag indicating whether fits should fail silently.}
}
\value{
An object of class fitdists (a list of \code{\link[fitdistrplus:fitdist]{fitdistrplus::fitdist()}} objects).
}
\description{
Fits one or more distributions to species sensitivity data.
}
\details{
By default the 'llogis', 'gamma' and 'lnorm'
distributions are fitted to the data.
The ssd_fit_dists function has also been
tested with the 'gompertz', 'lgumbel' and 'weibull' distributions.

If weight specifies a column in the data frame with positive integers,
weighted estimation occurs.
However, currently only the resultant parameter estimates are available (via coef).

If the \code{right} argument is different to the \code{left} argument then the data are considered to be censored.

The fits are performed using \code{\link[fitdistrplus:fitdist]{fitdistrplus::fitdist()}}
(and \code{\link[fitdistrplus:fitdistcens]{fitdistrplus::fitdistcens()}} in the case of censored data).
The method used is "mle" (maximum likelihood estimation)
which means that numerical optimization is carried out in
\code{\link[fitdistrplus:mledist]{fitdistrplus::mledist()}} using \code{\link[stats:optim]{stats::optim()}}
unless finite bounds are supplied in the (lower and upper) in which
it is carried out using \code{\link[stats:constrOptim]{stats::constrOptim()}}.
In both cases the "Nelder-Mead" method is used.
}
\examples{
ssd_fit_dists(boron_data)
data(fluazinam, package = "fitdistrplus")
ssd_fit_dists(fluazinam, left = "left", right = "right")
}
